/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.apache.http.config.Registry;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class InstrumentedPoolingHttpClientConnectionManager
extends PoolingHttpClientConnectionManager {
    static final String METRIC_NAME_CONNECTIONS_AVAILABLE = "connections-available";
    static final String METRIC_NAME_CONNECTIONS_LEASED = "connections-leased";
    static final String METRIC_NAME_CONNECTIONS_MAX = "connections-max";
    static final String METRIC_NAME_CONNECTIONS_PENDING = "connections-pending";
    private final MetricRegistry metricRegistry;

    InstrumentedPoolingHttpClientConnectionManager(MetricRegistry metricRegistry, Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long timeToLive, TimeUnit tunit) {
        super(socketFactoryRegistry, connFactory, schemePortResolver, dnsResolver, timeToLive, tunit);
        this.metricRegistry = metricRegistry;
        this.metricRegistry.register(METRIC_NAME_CONNECTIONS_AVAILABLE, (Metric)((Gauge)() -> this.getTotalStats().getAvailable()));
        this.metricRegistry.register(METRIC_NAME_CONNECTIONS_LEASED, (Metric)((Gauge)() -> this.getTotalStats().getLeased()));
        this.metricRegistry.register(METRIC_NAME_CONNECTIONS_MAX, (Metric)((Gauge)() -> this.getTotalStats().getMax()));
        this.metricRegistry.register(METRIC_NAME_CONNECTIONS_PENDING, (Metric)((Gauge)() -> this.getTotalStats().getPending()));
    }

    public void shutdown() {
        super.shutdown();
        this.metricRegistry.remove(METRIC_NAME_CONNECTIONS_AVAILABLE);
        this.metricRegistry.remove(METRIC_NAME_CONNECTIONS_LEASED);
        this.metricRegistry.remove(METRIC_NAME_CONNECTIONS_MAX);
        this.metricRegistry.remove(METRIC_NAME_CONNECTIONS_PENDING);
    }
}

