/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2LargeUploadPartService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2DeleteFeature
implements Delete {
    private static final Logger log = Logger.getLogger(B2DeleteFeature.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;

    public B2DeleteFeature(B2Session session, B2FileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            if (this.containerService.isContainer(file)) continue;
            callback.delete(file);
            if (file.getType().contains(AbstractPath.Type.upload)) {
                new B2LargeUploadPartService(this.session, this.fileid).delete(file.attributes().getVersionId());
                continue;
            }
            if (file.isDirectory()) {
                String fileid;
                try {
                    fileid = this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener());
                }
                catch (NotfoundException e) {
                    log.warn((Object)String.format("Ignore failure %s deleting placeholder file for %s", new Object[]{e, file}));
                    continue;
                }
                try {
                    ((B2ApiClient)this.session.getClient()).deleteFileVersion(this.containerService.getKey(file), fileid);
                    continue;
                }
                catch (B2ApiException e) {
                    log.warn((Object)String.format("Ignore failure %s deleting placeholder file for %s", e.getMessage(), file));
                    continue;
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }
            if (!file.isFile()) continue;
            try {
                ((B2ApiClient)this.session.getClient()).deleteFileVersion(this.containerService.getKey(file), this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
        for (Path file : files.keySet()) {
            try {
                if (!this.containerService.isContainer(file)) continue;
                callback.delete(file);
                ((B2ApiClient)this.session.getClient()).deleteBucket(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
    }

    public boolean isRecursive() {
        return false;
    }
}

