/*
 * Decompiled with CFR 0.152.
 */
package io.mikael.urlbuilder;

import io.mikael.urlbuilder.util.Decoder;
import io.mikael.urlbuilder.util.Encoder;
import io.mikael.urlbuilder.util.RuntimeMalformedURLException;
import io.mikael.urlbuilder.util.RuntimeURISyntaxException;
import io.mikael.urlbuilder.util.UrlParameterMultimap;
import java.io.IOException;
import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UrlBuilder {
    private static final Charset DEFAULT_ENCODING = Charset.forName("UTF-8");
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("((.*)@)?([^:]*)(:(\\d+))?");
    private final Decoder decoder;
    private final Encoder encoder;
    public final String scheme;
    public final String userInfo;
    public final String hostName;
    public final Integer port;
    public final String path;
    public final Map<String, List<String>> queryParameters;
    private final UrlParameterMultimap.Immutable queryParametersMultimap;
    public final String fragment;

    private UrlBuilder() {
        this(null, null, null, null, null, null, null, null, null);
    }

    private UrlBuilder(Decoder decoder, Encoder encoder, String scheme, String userInfo, String hostName, Integer port, String path, UrlParameterMultimap queryParametersMultimap, String fragment) {
        this.decoder = null == decoder ? new Decoder(DEFAULT_ENCODING) : decoder;
        this.encoder = null == encoder ? new Encoder(DEFAULT_ENCODING) : encoder;
        this.scheme = scheme;
        this.userInfo = userInfo;
        this.hostName = hostName;
        this.port = port;
        this.path = path;
        this.queryParametersMultimap = queryParametersMultimap == null ? UrlParameterMultimap.newMultimap().immutable() : queryParametersMultimap.immutable();
        this.queryParameters = this.queryParametersMultimap;
        this.fragment = fragment;
    }

    public static UrlBuilder empty() {
        return new UrlBuilder();
    }

    protected static UrlBuilder of(Decoder decoder, Encoder encoder, String scheme, String userInfo, String hostName, Integer port, String path, UrlParameterMultimap queryParameters, String fragment) {
        return new UrlBuilder(decoder, encoder, scheme, userInfo, hostName, port, path, queryParameters, fragment);
    }

    public static UrlBuilder fromString(String url) {
        return UrlBuilder.fromString(url, DEFAULT_ENCODING);
    }

    public static UrlBuilder fromString(String url, String inputEncoding) {
        return UrlBuilder.fromString(url, Charset.forName(inputEncoding));
    }

    public static UrlBuilder fromString(String url, Charset inputEncoding) {
        return UrlBuilder.fromString(url, new Decoder(inputEncoding));
    }

    public static UrlBuilder fromString(String url, Decoder decoder) {
        UrlParameterMultimap queryParametersMultimap;
        if (url == null || url.isEmpty()) {
            return new UrlBuilder();
        }
        Matcher m = URI_PATTERN.matcher(url);
        String scheme = null;
        String userInfo = null;
        String hostName = null;
        String path = null;
        String fragment = null;
        Integer port = null;
        if (m.find()) {
            Matcher n;
            scheme = m.group(2);
            if (m.group(4) != null && (n = AUTHORITY_PATTERN.matcher(m.group(4))).find()) {
                if (n.group(2) != null) {
                    userInfo = decoder.decodeUserInfo(n.group(2));
                }
                if (n.group(3) != null) {
                    hostName = IDN.toUnicode(n.group(3));
                }
                if (n.group(5) != null) {
                    port = Integer.parseInt(n.group(5));
                }
            }
            path = decoder.decodePath(m.group(5));
            queryParametersMultimap = decoder.parseQueryString(m.group(7));
            fragment = decoder.decodeFragment(m.group(9));
        } else {
            queryParametersMultimap = UrlParameterMultimap.newMultimap();
        }
        Encoder encoder = new Encoder(DEFAULT_ENCODING);
        return UrlBuilder.of(decoder, encoder, scheme, userInfo, hostName, port, path, queryParametersMultimap, fragment);
    }

    public static UrlBuilder fromUri(URI uri) {
        Decoder decoder = new Decoder(DEFAULT_ENCODING);
        return UrlBuilder.of(decoder, new Encoder(DEFAULT_ENCODING), uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort()), decoder.decodePath(uri.getRawPath()), decoder.parseQueryString(uri.getRawQuery()), decoder.decodeFragment(uri.getFragment()));
    }

    public static UrlBuilder fromUrl(URL url) {
        Decoder decoder = new Decoder(DEFAULT_ENCODING);
        return UrlBuilder.of(decoder, new Encoder(DEFAULT_ENCODING), url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort() == -1 ? null : Integer.valueOf(url.getPort()), decoder.decodePath(url.getPath()), decoder.parseQueryString(url.getQuery()), decoder.decodeFragment(url.getRef()));
    }

    public void toString(Appendable out) throws IOException {
        if (null != this.scheme) {
            out.append(this.scheme);
            out.append(':');
        }
        if (null != this.hostName) {
            out.append("//");
            if (this.userInfo != null) {
                out.append(this.encoder.encodeUserInfo(this.userInfo));
                out.append('@');
            }
            out.append(IDN.toASCII(this.hostName));
        }
        if (null != this.port) {
            out.append(':');
            out.append(Integer.toString(this.port));
        }
        if (null != this.path) {
            if (null != this.hostName && this.path.length() > 0 && this.path.charAt(0) != '/') {
                out.append('/');
            }
            out.append(this.encoder.encodePath(this.path));
        }
        if (null != this.queryParametersMultimap && !this.queryParametersMultimap.isEmpty()) {
            out.append('?');
            out.append(this.encoder.encodeQueryParameters(this.queryParametersMultimap));
        }
        if (null != this.fragment) {
            out.append('#');
            out.append(this.encoder.encodeFragment(this.fragment));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.toString(sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public URI toUriWithException() throws URISyntaxException {
        return new URI(this.toString());
    }

    public URI toUri() throws RuntimeURISyntaxException {
        try {
            return this.toUriWithException();
        }
        catch (URISyntaxException e) {
            throw new RuntimeURISyntaxException(e);
        }
    }

    public URL toUrlWithException() throws MalformedURLException {
        return new URL(this.toString());
    }

    public URL toUrl() throws RuntimeMalformedURLException {
        try {
            return this.toUrlWithException();
        }
        catch (MalformedURLException e) {
            throw new RuntimeMalformedURLException(e);
        }
    }

    public UrlBuilder withDecoder(Decoder decoder) {
        return UrlBuilder.of(decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withEncoder(Encoder encoder) {
        return UrlBuilder.of(this.decoder, encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder encodeAs(Charset charset) {
        Encoder encoder = new Encoder(charset);
        return UrlBuilder.of(this.decoder, encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder encodeAs(String charsetName) {
        Encoder encoder = new Encoder(Charset.forName(charsetName));
        return UrlBuilder.of(this.decoder, encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withScheme(String scheme) {
        return UrlBuilder.of(this.decoder, this.encoder, scheme, this.userInfo, this.hostName, this.port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withUserInfo(String userInfo) {
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, userInfo, this.hostName, this.port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withHost(String name) {
        String hostName = IDN.toUnicode(name);
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, hostName, this.port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withPort(Integer port) {
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, port, this.path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withPath(String path) {
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, path, this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withPath(String path, Charset encoding) {
        Decoder pathDecoder = new Decoder(encoding);
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, pathDecoder.decodePath(path), this.queryParametersMultimap, this.fragment);
    }

    public UrlBuilder withPath(String path, String encoding) {
        return this.withPath(path, Charset.forName(encoding));
    }

    public UrlBuilder withQuery(UrlParameterMultimap query) {
        UrlParameterMultimap q = query == null ? UrlParameterMultimap.newMultimap() : query.deepCopy();
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, q, this.fragment);
    }

    public UrlBuilder withQuery(String query) {
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, this.decoder.parseQueryString(query), this.fragment);
    }

    public UrlBuilder withQuery(String query, Charset encoding) {
        Decoder queryDecoder = new Decoder(encoding);
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, queryDecoder.parseQueryString(query), this.fragment);
    }

    public UrlBuilder withParameters(UrlParameterMultimap parameters) {
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, parameters, this.fragment);
    }

    public UrlBuilder addParameter(String key, String value) {
        UrlParameterMultimap qp = this.queryParametersMultimap.deepCopy().add(key, value);
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, qp, this.fragment);
    }

    public UrlBuilder setParameter(String key, String value) {
        UrlParameterMultimap qp = this.queryParametersMultimap.deepCopy().replaceValues(key, value);
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, qp, this.fragment);
    }

    public UrlBuilder removeParameter(String key, String value) {
        UrlParameterMultimap qp = this.queryParametersMultimap.deepCopy().remove(key, value);
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, qp, this.fragment);
    }

    public UrlBuilder removeParameters(String key) {
        UrlParameterMultimap qp = this.queryParametersMultimap.deepCopy().removeAllValues(key);
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, qp, this.fragment);
    }

    public UrlBuilder withFragment(String fragment) {
        return UrlBuilder.of(this.decoder, this.encoder, this.scheme, this.userInfo, this.hostName, this.port, this.path, this.queryParametersMultimap, fragment);
    }
}

