/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib;

import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.common.ReseedingSecureRandom;
import org.cryptomator.cryptolib.v1.CryptorProviderImpl;

public final class Cryptors {
    public static CryptorProvider version1(SecureRandom seeder) {
        ReseedingSecureRandom csprng = ReseedingSecureRandom.create(seeder);
        return new CryptorProviderImpl(csprng);
    }

    public static long cleartextSize(long ciphertextSize, Cryptor cryptor) {
        long additionalCleartextBytes;
        Preconditions.checkArgument((ciphertextSize >= 0L ? 1 : 0) != 0, (String)"expected ciphertextSize to be positive, but was %s", (long)ciphertextSize);
        long cleartextChunkSize = cryptor.fileContentCryptor().cleartextChunkSize();
        long ciphertextChunkSize = cryptor.fileContentCryptor().ciphertextChunkSize();
        long overheadPerChunk = ciphertextChunkSize - cleartextChunkSize;
        long numFullChunks = ciphertextSize / ciphertextChunkSize;
        long additionalCiphertextBytes = ciphertextSize % ciphertextChunkSize;
        if (additionalCiphertextBytes > 0L && additionalCiphertextBytes <= overheadPerChunk) {
            throw new IllegalArgumentException("Method not defined for input value " + ciphertextSize);
        }
        long l = additionalCleartextBytes = additionalCiphertextBytes == 0L ? 0L : additionalCiphertextBytes - overheadPerChunk;
        assert (additionalCleartextBytes >= 0L);
        return cleartextChunkSize * numFullChunks + additionalCleartextBytes;
    }

    public static long ciphertextSize(long cleartextSize, Cryptor cryptor) {
        long additionalCiphertextBytes;
        Preconditions.checkArgument((cleartextSize >= 0L ? 1 : 0) != 0, (String)"expected cleartextSize to be positive, but was %s", (long)cleartextSize);
        long cleartextChunkSize = cryptor.fileContentCryptor().cleartextChunkSize();
        long ciphertextChunkSize = cryptor.fileContentCryptor().ciphertextChunkSize();
        long overheadPerChunk = ciphertextChunkSize - cleartextChunkSize;
        long numFullChunks = cleartextSize / cleartextChunkSize;
        long additionalCleartextBytes = cleartextSize % cleartextChunkSize;
        long l = additionalCiphertextBytes = additionalCleartextBytes == 0L ? 0L : additionalCleartextBytes + overheadPerChunk;
        assert (additionalCiphertextBytes >= 0L);
        return ciphertextChunkSize * numFullChunks + additionalCiphertextBytes;
    }

    public static byte[] changePassphrase(CryptorProvider cryptorProvider, byte[] masterkey, CharSequence oldPassphrase, CharSequence newPassphrase) throws InvalidPassphraseException {
        return Cryptors.changePassphrase(cryptorProvider, masterkey, new byte[0], oldPassphrase, newPassphrase);
    }

    public static byte[] changePassphrase(CryptorProvider cryptorProvider, byte[] masterkey, byte[] pepper, CharSequence oldPassphrase, CharSequence newPassphrase) throws InvalidPassphraseException {
        KeyFile keyFile = KeyFile.parse(masterkey);
        try (Cryptor cryptor = cryptorProvider.createFromKeyFile(keyFile, oldPassphrase, pepper, keyFile.getVersion());){
            byte[] byArray = cryptor.writeKeysToMasterkeyFile(newPassphrase, pepper, keyFile.getVersion()).serialize();
            return byArray;
        }
    }

    public static byte[] exportRawKey(CryptorProvider cryptorProvider, byte[] masterkey, byte[] pepper, CharSequence passphrase) {
        KeyFile keyFile = KeyFile.parse(masterkey);
        try (Cryptor cryptor = cryptorProvider.createFromKeyFile(keyFile, passphrase, pepper, keyFile.getVersion());){
            byte[] byArray = cryptor.getRawKey();
            return byArray;
        }
    }

    public static byte[] restoreRawKey(CryptorProvider cryptorProvider, byte[] rawKey, byte[] pepper, CharSequence passphrase, int vaultVersion) {
        try (Cryptor cryptor = cryptorProvider.createFromRawKey(rawKey);){
            byte[] byArray = cryptor.writeKeysToMasterkeyFile(passphrase, pepper, vaultVersion).serialize();
            return byArray;
        }
    }
}

