/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.binding.foundation.NSAppleScript;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TerminalService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.sun.jna.ptr.ByReference;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObjectByReference;

public class ApplescriptTerminalService
implements TerminalService {
    private static final Logger log = Logger.getLogger(ApplescriptTerminalService.class);
    private final ApplicationFinder finder = ApplicationFinderFactory.get();
    private final Preferences preferences = PreferencesFactory.get();

    public void open(Host host, Path workdir) throws AccessDeniedException {
        ObjCObjectByReference error;
        NSAppleScript as;
        String applescript;
        Application application;
        boolean identity = host.getCredentials().isPublicKeyAuthentication();
        switch (StringUtils.lowerCase((String)this.finder.find(".command").getIdentifier())) {
            case "com.googlecode.iterm2": 
            case "com.apple.terminal": {
                application = this.finder.find(".command");
                break;
            }
            default: {
                log.warn((Object)String.format("Unsupported application %s assigned", this.finder.find(".command")));
                application = this.finder.getDescription(this.preferences.getProperty("terminal.bundle.identifier"));
            }
        }
        if (!this.finder.isInstalled(application)) {
            throw new LocalAccessDeniedException("Unable to determine default Terminal application");
        }
        String ssh = MessageFormat.format(this.preferences.getProperty("terminal.command.ssh"), identity ? String.format("-i \"%s\"", host.getCredentials().getIdentity().getAbsolute()) : "", host.getCredentials().getUsername(), host.getHostname(), String.valueOf(host.getPort()), this.escape(workdir.getAbsolute()));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Execute SSH command %s", ssh));
        }
        ssh = StringUtils.replace((String)ssh, (String)"\\", (String)"\\\\");
        ssh = StringUtils.replace((String)ssh, (String)"\"", (String)"\\\"");
        if (log.isInfoEnabled()) {
            log.info((Object)("Escaped SSH Command for Applescript:" + ssh));
        }
        switch (application.getIdentifier()) {
            case "com.googlecode.iterm2": {
                applescript = MessageFormat.format(this.preferences.getProperty("terminal.command.iterm2"), ssh);
                break;
            }
            default: {
                applescript = MessageFormat.format(this.preferences.getProperty("terminal.command.default"), ssh);
            }
        }
        String command = "tell application \"" + application.getName() + "\"\nactivate\n" + applescript + "\nend tell";
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Execute AppleScript %s", command));
        }
        if (null == (as = NSAppleScript.createWithSource((String)command)).executeAndReturnError((ByReference)(error = new ObjCObjectByReference()))) {
            NSDictionary d = (NSDictionary)error.getValueAs(NSDictionary.class);
            throw new LocalAccessDeniedException(String.format("Failure running script in %s. %s", application.getName(), d.objectForKey("NSAppleScriptErrorBriefMessage")));
        }
    }

    protected String escape(String path) {
        StringBuilder escaped = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (StringUtils.isAlphanumeric((CharSequence)String.valueOf(c))) {
                escaped.append(c);
                continue;
            }
            escaped.append("\\").append(c);
        }
        return escaped.toString();
    }
}

