/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DefaultHostPasswordStore;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.library.Native;
import org.apache.log4j.Logger;

public final class KeychainPasswordStore
extends DefaultHostPasswordStore
implements PasswordStore {
    private static final Logger log = Logger.getLogger(KeychainPasswordStore.class);

    public synchronized native String getInternetPasswordFromKeychain(String var1, int var2, String var3, String var4);

    public synchronized native String getPasswordFromKeychain(String var1, String var2);

    public synchronized native boolean addPasswordToKeychain(String var1, String var2, String var3);

    public synchronized native boolean addInternetPasswordToKeychain(String var1, int var2, String var3, String var4, String var5);

    public String getPassword(Scheme scheme, int port, String hostname, String user) {
        return this.getInternetPasswordFromKeychain(scheme.name(), port, hostname, user);
    }

    public void addPassword(Scheme scheme, int port, String hostname, String user, String password) throws LocalAccessDeniedException {
        if (!this.addInternetPasswordToKeychain(scheme.name(), port, hostname, user, password)) {
            throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", user));
        }
    }

    public String getPassword(String serviceName, String accountName) {
        return this.getPasswordFromKeychain(serviceName, accountName);
    }

    public void addPassword(String serviceName, String accountName, String password) throws LocalAccessDeniedException {
        if (!this.addPasswordToKeychain(serviceName, accountName, password)) {
            throw new LocalAccessDeniedException(String.format("Failure saving credentials for %s in Keychain", accountName));
        }
    }

    static {
        Native.load((String)"core");
    }
}

