/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.i18n;

import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.i18n.Locale;
import ch.cyberduck.core.preferences.BundleApplicationResourcesFinder;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.Collections;

public class BundleLocale
implements Locale {
    private final NSBundle bundle;
    private final LRUCache<String, String> cache = LRUCache.build((long)1000L);

    public BundleLocale() {
        this(new BundleApplicationResourcesFinder().bundle());
    }

    public BundleLocale(NSBundle bundle) {
        this.bundle = bundle;
    }

    public String localize(String key, String table) {
        String identifier = String.format("%s.%s", table, key);
        if (!this.cache.contains((Object)identifier)) {
            this.cache.put((Object)identifier, (Object)this.bundle.localizedString(key, table));
        }
        return (String)this.cache.get((Object)identifier);
    }

    public void setDefault(String language) {
        Preferences preferences = PreferencesFactory.get();
        if (null == language) {
            preferences.deleteProperty("AppleLanguages");
        } else {
            preferences.setProperty("AppleLanguages", Collections.singletonList(language));
        }
        this.cache.clear();
    }
}

