/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.logging;

import ch.cyberduck.core.library.Native;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class UnifiedSystemLogAppender
extends AppenderSkeleton {
    public static final int OS_LOG_TYPE_DEFAULT = 0;
    public static final int OS_LOG_TYPE_INFO = 1;
    public static final int OS_LOG_TYPE_DEBUG = 2;
    public static final int OS_LOG_TYPE_ERROR = 16;
    public static final int OS_LOG_TYPE_FAULT = 17;

    protected void append(LoggingEvent event) {
        String[] trace;
        if (null == event.getMessage()) {
            return;
        }
        String logger = String.format("%s %s", event.getThreadName(), event.getLogger().getName());
        switch (event.getLevel().toInt()) {
            case 40000: 
            case 50000: {
                this.log(16, logger, event.getMessage().toString());
                break;
            }
            case 5000: 
            case 10000: {
                this.log(2, logger, event.getMessage().toString());
                break;
            }
            case 20000: {
                this.log(1, logger, event.getMessage().toString());
                break;
            }
            default: {
                this.log(0, logger, event.getMessage().toString());
            }
        }
        if (this.layout.ignoresThrowable() && (trace = event.getThrowableStrRep()) != null) {
            for (String t : trace) {
                this.log(0, logger, t);
            }
        }
    }

    public native void log(int var1, String var2, String var3);

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    static {
        Native.load((String)"core");
    }
}

