/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.binding.foundation.ServiceManagementFunctions;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.FinderLocal;
import ch.cyberduck.core.local.LaunchServicesApplicationFinder;
import ch.cyberduck.core.preferences.ApplicationLoginRegistry;
import ch.cyberduck.core.preferences.BundleApplicationResourcesFinder;
import org.apache.log4j.Logger;

public class ServiceManagementApplicationLoginRegistry
implements ApplicationLoginRegistry {
    private static final Logger log = Logger.getLogger(ServiceManagementApplicationLoginRegistry.class);
    private final LaunchServicesApplicationFinder finder = new LaunchServicesApplicationFinder();

    public boolean register(Application application) {
        FinderLocal helper = new FinderLocal(new BundleApplicationResourcesFinder().find().getParent(), String.format("Library/LoginItems/%s.app", application.getName()));
        if (!this.finder.register(helper)) {
            log.warn((Object)String.format("Failed to register %s (%s) with launch services", new Object[]{helper, this.finder.getDescription(application.getIdentifier())}));
        }
        if (!ServiceManagementFunctions.library.SMLoginItemSetEnabled(application.getIdentifier(), true)) {
            log.warn((Object)String.format("Failed to register %s as login item", application));
            return false;
        }
        return true;
    }

    public boolean unregister(Application application) {
        if (!ServiceManagementFunctions.library.SMLoginItemSetEnabled(application.getIdentifier(), false)) {
            log.warn((Object)String.format("Failed to remove %s as login item", application));
            return false;
        }
        return true;
    }
}

