/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.local.FinderLocal;
import ch.cyberduck.core.local.FinderSidebarService;
import ch.cyberduck.core.local.SidebarService;
import ch.cyberduck.core.preferences.ApplicationLoginRegistry;

public class SharedFileListApplicationLoginRegistry
implements ApplicationLoginRegistry {
    private final FinderSidebarService service = new FinderSidebarService(SidebarService.List.login);
    private final ApplicationFinder finder;

    public SharedFileListApplicationLoginRegistry() {
        this(ApplicationFinderFactory.get());
    }

    public SharedFileListApplicationLoginRegistry(ApplicationFinder finder) {
        this.finder = finder;
    }

    public boolean register(Application application) {
        try {
            if (this.finder.isInstalled(application)) {
                this.service.add(new FinderLocal(NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(application.getIdentifier())));
                return true;
            }
            return false;
        }
        catch (LocalAccessDeniedException e) {
            return false;
        }
    }

    public boolean unregister(Application application) {
        try {
            if (this.finder.isInstalled(application)) {
                this.service.remove(new FinderLocal(NSWorkspace.sharedWorkspace().absolutePathForAppBundleWithIdentifier(application.getIdentifier())));
                return true;
            }
            return false;
        }
        catch (LocalAccessDeniedException e) {
            return false;
        }
    }
}

