/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.threading.NSInvocationOperation;
import ch.cyberduck.core.threading.NSOperation;
import ch.cyberduck.core.threading.NSOperationQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSArray;
import org.rococoa.cocoa.foundation.NSAutoreleasePool;

public class DispatchExecutorService
extends AbstractExecutorService {
    private static final Selector RUN_SELECTOR = Foundation.selector((String)"run");
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private final NSOperationQueue queue;
    private volatile State state = State.RUNNING;
    private final ReentrantLock shutdownLock = new ReentrantLock();
    private final Condition shutdownCondition = this.shutdownLock.newCondition();
    private final Map<ID, InvocationFutureTask<?>> tasks = new ConcurrentHashMap();

    public DispatchExecutorService() {
        this.queue = NSOperationQueue.CLASS.alloc().init();
    }

    @Override
    public void shutdown() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(shutdownPerm);
        }
        try {
            this.shutdownLock.lock();
            this.state = State.SHUTDOWN;
            this.terminateIfDone(this.queue.operationCount().intValue() == 0);
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(shutdownPerm);
        }
        return DispatchExecutorService.doWithAutoreleasePool(new Callable<List<Runnable>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Runnable> call() {
                try {
                    DispatchExecutorService.this.shutdownLock.lock();
                    DispatchExecutorService.this.state = State.SHUTDOWN;
                    NSArray queuedTasks = DispatchExecutorService.this.queue.operations();
                    ArrayList<Runnable> result = new ArrayList<Runnable>(queuedTasks.count());
                    for (int i = 0; i < queuedTasks.count(); ++i) {
                        NSOperation o = (NSOperation)Rococoa.cast((ObjCObject)queuedTasks.objectAtIndex(i), NSOperation.class);
                        InvocationFutureTask task = (InvocationFutureTask)DispatchExecutorService.this.tasks.get(o.id());
                        if (task == null || o.isFinished() || o.isCancelled()) continue;
                        result.add(task.getOriginalRunnable());
                    }
                    DispatchExecutorService.this.queue.cancelAllOperations();
                    DispatchExecutorService.this.tasks.clear();
                    DispatchExecutorService.this.terminateIfDone(DispatchExecutorService.this.queue.operationCount().intValue() == 0);
                    ArrayList<Runnable> arrayList = result;
                    return arrayList;
                }
                finally {
                    DispatchExecutorService.this.shutdownLock.unlock();
                }
            }
        });
    }

    @Override
    public boolean isShutdown() {
        return this.state != State.RUNNING;
    }

    @Override
    public boolean isTerminated() {
        return this.state == State.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long wait = unit.toNanos(timeout);
        this.shutdownLock.lock();
        try {
            while (!this.isTerminated()) {
                if (wait <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                wait = this.shutdownCondition.awaitNanos(wait);
                this.terminateIfDone(this.queue.operationCount().intValue() == 0);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.shutdownLock.lock();
            if (this.state != State.RUNNING) {
                throw new RejectedExecutionException("Executor is not running");
            }
            InvocationFutureTask task = command instanceof InvocationFutureTask ? (InvocationFutureTask)command : (InvocationFutureTask)this.newTaskFor(command, null);
            this.queue.addOperation(task.getInvocationOperation());
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new InvocationFutureTask<T>(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return super.newTaskFor(callable);
    }

    private void terminateIfDone(boolean queueEmpty) {
        try {
            this.shutdownLock.lock();
            if (this.state == State.SHUTDOWN && queueEmpty) {
                this.shutdownCondition.signalAll();
                this.queue.setSuspended(true);
                this.state = State.TERMINATED;
            }
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    private static <R> R doWithAutoreleasePool(Callable<R> callable) {
        NSAutoreleasePool pool = null;
        try {
            pool = NSAutoreleasePool.new_();
            R r = callable.call();
            return r;
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        finally {
            if (pool != null) {
                pool.drain();
            }
        }
    }

    private class InvocationFutureTask<V>
    extends FutureTask<V> {
        private final NSInvocationOperation invocation;
        private final ObjCObject proxy;
        private final Runnable originalRunnable;

        public InvocationFutureTask(Runnable r, V result) {
            super(r, result);
            this.originalRunnable = r;
            this.proxy = Rococoa.proxy((Object)this);
            this.invocation = this.createInvocation(this.proxy);
            DispatchExecutorService.this.tasks.put(this.invocation.id(), this);
        }

        public InvocationFutureTask(Callable<V> callable) {
            super(callable);
            this.originalRunnable = this;
            this.proxy = Rococoa.proxy((Object)this);
            this.invocation = this.createInvocation(this.proxy);
            DispatchExecutorService.this.tasks.put(this.invocation.id(), this);
        }

        private NSInvocationOperation createInvocation(final ObjCObject toInvoke) {
            return (NSInvocationOperation)((Object)DispatchExecutorService.doWithAutoreleasePool(new Callable<NSInvocationOperation>(){

                @Override
                public NSInvocationOperation call() {
                    NSInvocationOperation result = NSInvocationOperation.CLASS.alloc();
                    result = result.initWithTarget_selector_object(toInvoke.id(), RUN_SELECTOR, null);
                    return result;
                }
            }));
        }

        public NSInvocationOperation getInvocationOperation() {
            return this.invocation;
        }

        public Runnable getOriginalRunnable() {
            return this.originalRunnable;
        }

        @Override
        public void run() {
            try {
                super.run();
                DispatchExecutorService.this.tasks.remove(this.invocation.id());
            }
            catch (Throwable throwable) {
                DispatchExecutorService.this.tasks.remove(this.invocation.id());
                if (DispatchExecutorService.this.state == State.SHUTDOWN) {
                    DispatchExecutorService.this.terminateIfDone(DispatchExecutorService.this.queue.operationCount().intValue() <= 1);
                }
                throw throwable;
            }
            if (DispatchExecutorService.this.state == State.SHUTDOWN) {
                DispatchExecutorService.this.terminateIfDone(DispatchExecutorService.this.queue.operationCount().intValue() <= 1);
            }
        }
    }

    private static enum State {
        RUNNING,
        SHUTDOWN,
        TERMINATED;

    }
}

