/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.Function;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.rococoa.ID;
import org.rococoa.RococoaException;
import org.rococoa.Selector;
import org.rococoa.internal.MsgSendLibrary;
import org.rococoa.internal.Pair;
import org.rococoa.internal.RococoaTypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MsgSendHandler
implements InvocationHandler {
    private final String OPTION_INVOKING_METHOD = "invoking-method";
    private static final int I386_STRET_CUTOFF = 9;
    private static final int IA64_STRET_CUTOFF = 17;
    private static final int stretCutoff = NativeLong.SIZE == 8 ? 17 : 9;
    private static final boolean ppc = System.getProperty("os.arch").trim().equalsIgnoreCase("ppc");
    private static final Method OBJC_MSGSEND;
    private static final Method OBJC_MSGSEND_STRET;
    private final Pair<Method, Function> objc_msgSend_stret_Pair;
    private final Pair<Method, Function> objc_msgSend_Pair;
    private RococoaTypeMapper rococoaTypeMapper = new RococoaTypeMapper();

    public MsgSendHandler(Function objc_msgSend_Function, Function objc_msgSend_stret_Function) {
        this.objc_msgSend_Pair = new Pair<Method, Function>(OBJC_MSGSEND, objc_msgSend_Function);
        this.objc_msgSend_stret_Pair = new Pair<Method, Function>(OBJC_MSGSEND_STRET, objc_msgSend_stret_Function);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class returnTypeForThisCall = (Class)args[0];
        Object[] argsWithoutReturnType = this.removeReturnTypeFrom(args);
        HashMap<String, RococoaTypeMapper> options = new HashMap<String, RococoaTypeMapper>(1);
        options.put("type-mapper", this.rococoaTypeMapper);
        Pair<Method, Function> invocation = this.invocationFor(returnTypeForThisCall);
        options.put("invoking-method", (RococoaTypeMapper)((Object)invocation.a));
        return ((Function)invocation.b).invoke(returnTypeForThisCall, argsWithoutReturnType, options);
    }

    private Object[] removeReturnTypeFrom(Object[] args) {
        Object[] result = new Object[args.length - 1];
        System.arraycopy(args, 1, result, 0, args.length - 2);
        return result;
    }

    private Pair<Method, Function> invocationFor(Class<?> returnTypeForThisCall) {
        boolean isStructByValue;
        boolean isStruct = Structure.class.isAssignableFrom(returnTypeForThisCall);
        boolean bl = isStructByValue = isStruct && Structure.ByValue.class.isAssignableFrom(returnTypeForThisCall);
        if (!isStructByValue) {
            return this.objc_msgSend_Pair;
        }
        try {
            if (ppc) {
                return this.objc_msgSend_stret_Pair;
            }
            Structure prototype = (Structure)returnTypeForThisCall.newInstance();
            return prototype.size() < stretCutoff ? this.objc_msgSend_Pair : this.objc_msgSend_stret_Pair;
        }
        catch (InstantiationException e) {
            throw new RococoaException(e);
        }
        catch (IllegalAccessException e) {
            throw new RococoaException(e);
        }
    }

    static {
        try {
            OBJC_MSGSEND = MsgSendLibrary.class.getDeclaredMethod("objc_msgSend", ID.class, Selector.class, Object[].class);
            OBJC_MSGSEND_STRET = MsgSendLibrary.class.getDeclaredMethod("objc_msgSend_stret", ID.class, Selector.class, Object[].class);
        }
        catch (NoSuchMethodException x) {
            throw new RococoaException(x);
        }
    }
}

