/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetDegradedBlobsSpectraS3Request
extends AbstractPaginationRequest {
    private String blobId;
    private String bucketId;
    private String ds3ReplicationRuleId;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String persistenceRuleId;

    public GetDegradedBlobsSpectraS3Request withBlobId(UUID blobId) {
        this.blobId = blobId.toString();
        this.updateQueryParam("blob_id", blobId);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withBlobId(String blobId) {
        this.blobId = blobId;
        this.updateQueryParam("blob_id", blobId);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withDs3ReplicationRuleId(UUID ds3ReplicationRuleId) {
        this.ds3ReplicationRuleId = ds3ReplicationRuleId.toString();
        this.updateQueryParam("ds3_replication_rule_id", ds3ReplicationRuleId);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withDs3ReplicationRuleId(String ds3ReplicationRuleId) {
        this.ds3ReplicationRuleId = ds3ReplicationRuleId;
        this.updateQueryParam("ds3_replication_rule_id", ds3ReplicationRuleId);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withPersistenceRuleId(UUID persistenceRuleId) {
        this.persistenceRuleId = persistenceRuleId.toString();
        this.updateQueryParam("persistence_rule_id", persistenceRuleId);
        return this;
    }

    public GetDegradedBlobsSpectraS3Request withPersistenceRuleId(String persistenceRuleId) {
        this.persistenceRuleId = persistenceRuleId;
        this.updateQueryParam("persistence_rule_id", persistenceRuleId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/degraded_blob";
    }

    public String getBlobId() {
        return this.blobId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getDs3ReplicationRuleId() {
        return this.ds3ReplicationRuleId;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getPersistenceRuleId() {
        return this.persistenceRuleId;
    }
}

