/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class ImportTapeSpectraS3Request
extends AbstractRequest {
    private final String tapeId;
    private String dataPolicyId;
    private Priority priority;
    private String storageDomainId;
    private String userId;
    private Priority verifyDataAfterImport;
    private boolean verifyDataPriorToImport;

    public ImportTapeSpectraS3Request(UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.getQueryParams().put("operation", "import");
    }

    public ImportTapeSpectraS3Request(String tapeId) {
        this.tapeId = tapeId;
        this.getQueryParams().put("operation", "import");
    }

    public ImportTapeSpectraS3Request withDataPolicyId(UUID dataPolicyId) {
        this.dataPolicyId = dataPolicyId.toString();
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportTapeSpectraS3Request withDataPolicyId(String dataPolicyId) {
        this.dataPolicyId = dataPolicyId;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        return this;
    }

    public ImportTapeSpectraS3Request withPriority(Priority priority) {
        this.priority = priority;
        this.updateQueryParam("priority", priority);
        return this;
    }

    public ImportTapeSpectraS3Request withStorageDomainId(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public ImportTapeSpectraS3Request withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public ImportTapeSpectraS3Request withUserId(UUID userId) {
        this.userId = userId.toString();
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public ImportTapeSpectraS3Request withUserId(String userId) {
        this.userId = userId;
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public ImportTapeSpectraS3Request withVerifyDataAfterImport(Priority verifyDataAfterImport) {
        this.verifyDataAfterImport = verifyDataAfterImport;
        this.updateQueryParam("verify_data_after_import", verifyDataAfterImport);
        return this;
    }

    public ImportTapeSpectraS3Request withVerifyDataPriorToImport(boolean verifyDataPriorToImport) {
        this.verifyDataPriorToImport = verifyDataPriorToImport;
        this.updateQueryParam("verify_data_prior_to_import", verifyDataPriorToImport);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape/" + this.tapeId;
    }

    public String getTapeId() {
        return this.tapeId;
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Priority getVerifyDataAfterImport() {
        return this.verifyDataAfterImport;
    }

    public boolean getVerifyDataPriorToImport() {
        return this.verifyDataPriorToImport;
    }
}

