/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.WritePreferenceLevel;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutPoolStorageDomainMemberSpectraS3Request
extends AbstractRequest {
    private final String poolPartitionId;
    private final String storageDomainId;
    private WritePreferenceLevel writePreference;

    public PutPoolStorageDomainMemberSpectraS3Request(UUID poolPartitionId, UUID storageDomainId) {
        this.poolPartitionId = poolPartitionId.toString();
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("pool_partition_id", poolPartitionId);
        this.updateQueryParam("storage_domain_id", storageDomainId);
    }

    public PutPoolStorageDomainMemberSpectraS3Request(String poolPartitionId, String storageDomainId) {
        this.poolPartitionId = poolPartitionId;
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("pool_partition_id", poolPartitionId);
        this.updateQueryParam("storage_domain_id", storageDomainId);
    }

    public PutPoolStorageDomainMemberSpectraS3Request withWritePreference(WritePreferenceLevel writePreference) {
        this.writePreference = writePreference;
        this.updateQueryParam("write_preference", writePreference);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/storage_domain_member";
    }

    public String getPoolPartitionId() {
        return this.poolPartitionId;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public WritePreferenceLevel getWritePreference() {
        return this.writePreference;
    }
}

