/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.TargetReadPreferenceType;
import com.spectralogic.ds3client.networking.HttpVerb;

public class RegisterAzureTargetSpectraS3Request
extends AbstractRequest {
    private final String accountKey;
    private final String accountName;
    private final String name;
    private Integer autoVerifyFrequencyInDays;
    private String cloudBucketPrefix;
    private String cloudBucketSuffix;
    private TargetReadPreferenceType defaultReadPreference;
    private boolean https;
    private boolean permitGoingOutOfSync;

    public RegisterAzureTargetSpectraS3Request(String accountKey, String accountName, String name) {
        this.accountKey = accountKey;
        this.accountName = accountName;
        this.name = name;
        this.updateQueryParam("account_key", accountKey);
        this.updateQueryParam("account_name", accountName);
        this.updateQueryParam("name", name);
    }

    public RegisterAzureTargetSpectraS3Request withAutoVerifyFrequencyInDays(Integer autoVerifyFrequencyInDays) {
        this.autoVerifyFrequencyInDays = autoVerifyFrequencyInDays;
        this.updateQueryParam("auto_verify_frequency_in_days", autoVerifyFrequencyInDays);
        return this;
    }

    public RegisterAzureTargetSpectraS3Request withCloudBucketPrefix(String cloudBucketPrefix) {
        this.cloudBucketPrefix = cloudBucketPrefix;
        this.updateQueryParam("cloud_bucket_prefix", cloudBucketPrefix);
        return this;
    }

    public RegisterAzureTargetSpectraS3Request withCloudBucketSuffix(String cloudBucketSuffix) {
        this.cloudBucketSuffix = cloudBucketSuffix;
        this.updateQueryParam("cloud_bucket_suffix", cloudBucketSuffix);
        return this;
    }

    public RegisterAzureTargetSpectraS3Request withDefaultReadPreference(TargetReadPreferenceType defaultReadPreference) {
        this.defaultReadPreference = defaultReadPreference;
        this.updateQueryParam("default_read_preference", defaultReadPreference);
        return this;
    }

    public RegisterAzureTargetSpectraS3Request withHttps(boolean https) {
        this.https = https;
        this.updateQueryParam("https", https);
        return this;
    }

    public RegisterAzureTargetSpectraS3Request withPermitGoingOutOfSync(boolean permitGoingOutOfSync) {
        this.permitGoingOutOfSync = permitGoingOutOfSync;
        this.updateQueryParam("permit_going_out_of_sync", permitGoingOutOfSync);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/azure_target";
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getName() {
        return this.name;
    }

    public Integer getAutoVerifyFrequencyInDays() {
        return this.autoVerifyFrequencyInDays;
    }

    public String getCloudBucketPrefix() {
        return this.cloudBucketPrefix;
    }

    public String getCloudBucketSuffix() {
        return this.cloudBucketSuffix;
    }

    public TargetReadPreferenceType getDefaultReadPreference() {
        return this.defaultReadPreference;
    }

    public boolean getHttps() {
        return this.https;
    }

    public boolean getPermitGoingOutOfSync() {
        return this.permitGoingOutOfSync;
    }
}

