/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class VerifyDs3TargetSpectraS3Request
extends AbstractRequest {
    private final String ds3Target;
    private boolean fullDetails;

    public VerifyDs3TargetSpectraS3Request(String ds3Target) {
        this.ds3Target = ds3Target;
        this.getQueryParams().put("operation", "verify");
    }

    public VerifyDs3TargetSpectraS3Request withFullDetails(boolean fullDetails) {
        this.fullDetails = fullDetails;
        if (this.fullDetails) {
            this.getQueryParams().put("full_details", null);
        } else {
            this.getQueryParams().remove("full_details");
        }
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/ds3_target/" + this.ds3Target;
    }

    public String getDs3Target() {
        return this.ds3Target;
    }

    public boolean getFullDetails() {
        return this.fullDetails;
    }
}

