/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.models.bulk;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.spectralogic.ds3client.serializer.Views;
import java.util.Objects;
import java.util.UUID;

public class Ds3Object {
    @JacksonXmlProperty(isAttribute=true, localName="Name")
    private String name;
    @JsonView(value={Views.PutObject.class})
    @JacksonXmlProperty(isAttribute=true, localName="Size")
    private long size;
    @JsonView(value={Views.GetObject.class})
    @JacksonXmlProperty(isAttribute=true, localName="VersionId")
    private String versionId;

    public Ds3Object() {
    }

    public Ds3Object(String name, long size) {
        this.name = name;
        this.size = size;
        this.versionId = null;
    }

    public Ds3Object(String name, UUID versionId) {
        this.name = name;
        this.size = 0L;
        this.versionId = versionId.toString();
    }

    public Ds3Object(String name, String versionId) {
        this.name = name;
        this.size = 0L;
        this.versionId = versionId;
    }

    public Ds3Object(String name) {
        this.name = name;
        this.size = 0L;
        this.versionId = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String toString() {
        return this.name + ":" + this.size;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.size, this.versionId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ds3Object)) {
            return false;
        }
        Ds3Object ds3Obj = (Ds3Object)obj;
        return Objects.equals(ds3Obj.getName(), this.getName()) && ds3Obj.getSize() == this.getSize() && Objects.equals(ds3Obj.versionId, this.getVersionId());
    }
}

