/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.google.common.collect.ImmutableSet;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.GetJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetJobSpectraS3Response;
import com.spectralogic.ds3client.commands.spectrads3.GetJobsSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetJobsSpectraS3Response;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.Job;
import com.spectralogic.ds3client.models.JobRequestType;
import com.spectralogic.ds3client.models.JobStatus;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class JobUtils {
    private JobUtils() {
    }

    public static List<UUID> findJob(Ds3Client client, JobRequestType type, String bucketName, Set<String> fileNames) throws IOException {
        ImmutableSet files = ImmutableSet.copyOf(fileNames);
        GetJobsSpectraS3Response response = client.getJobsSpectraS3(new GetJobsSpectraS3Request());
        ArrayList<UUID> jobIds = new ArrayList<UUID>();
        block0: for (Job job : response.getJobListResult().getJobs()) {
            if (!job.getBucketName().equals(bucketName) || job.getStatus() != JobStatus.IN_PROGRESS || job.getRequestType() != type) continue;
            GetJobSpectraS3Response jobResponse = client.getJobSpectraS3(new GetJobSpectraS3Request(job.getJobId().toString()));
            MasterObjectList masterObjectList = jobResponse.getMasterObjectListResult();
            for (Objects objects : masterObjectList.getObjects()) {
                if (!JobUtils.chunkAndSetIntersects(objects, (ImmutableSet<String>)files)) continue;
                jobIds.add(job.getJobId());
                continue block0;
            }
        }
        return jobIds;
    }

    private static boolean chunkAndSetIntersects(Objects objects, ImmutableSet<String> fileNames) {
        for (BulkObject blobApiBean : objects.getObjects()) {
            if (!fileNames.contains((Object)blobApiBean.getName())) continue;
            return true;
        }
        return false;
    }
}

