/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class SeekableByteChannelInputStream
extends InputStream {
    private final SeekableByteChannel seekableByteChannel;
    private long markPosition = 0L;

    public SeekableByteChannelInputStream(SeekableByteChannel seekableByteChannel) {
        this.seekableByteChannel = seekableByteChannel;
    }

    @Override
    public int read() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[1]);
        int bytesRead = this.seekableByteChannel.read(buffer);
        if (bytesRead > 0) {
            buffer.position(0);
            return buffer.get();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(b);
        buffer.position(off);
        buffer.limit(off + len);
        int bytesRead = this.seekableByteChannel.read(buffer);
        if (bytesRead > 0) {
            return bytesRead;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        this.seekableByteChannel.position(this.seekableByteChannel.position() + n);
        return this.seekableByteChannel.position();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.markPosition = this.seekableByteChannel.position();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reset() throws IOException {
        this.seekableByteChannel.position(this.markPosition);
        this.markPosition = 0L;
    }

    @Override
    public void close() throws IOException {
        this.seekableByteChannel.close();
    }
}

