/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.google.common.base.Joiner;
import com.spectralogic.ds3client.models.common.SignatureDetails;
import com.spectralogic.ds3client.utils.MultiMap;
import java.nio.charset.Charset;
import java.security.SignatureException;
import java.util.Collection;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Signature {
    private static final Logger LOG = LoggerFactory.getLogger(Signature.class);
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String calculateRFC2104HMAC(String data, String key) throws SignatureException {
        String result;
        LOG.debug("String to sign: {}", (Object)data.replace("\n", "\\n"));
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(Charset.forName("UTF-8")), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(Charset.forName("UTF-8")));
            result = Base64.encodeBase64String((byte[])rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC: " + e.getMessage(), e);
        }
        return result.trim();
    }

    public static String signature(SignatureDetails signatureDetails) throws SignatureException {
        return Signature.calculateRFC2104HMAC(String.valueOf((Object)signatureDetails.getVerb()) + '\n' + signatureDetails.getContentMd5() + '\n' + signatureDetails.getContentType() + '\n' + signatureDetails.getDate() + '\n' + signatureDetails.getCanonicalizedAmzHeaders() + signatureDetails.getCanonicalizedResource(), signatureDetails.getCredentials().getKey());
    }

    public static String canonicalizeResource(String path, Map<String, String> queryParams) {
        StringBuilder canonicalizedResource = new StringBuilder();
        canonicalizedResource.append(path);
        if (queryParams != null) {
            if (queryParams.containsKey("delete")) {
                canonicalizedResource.append("?delete");
            }
            if (queryParams.containsKey("uploads")) {
                canonicalizedResource.append("?uploads");
            }
            if (queryParams.containsKey("versioning")) {
                canonicalizedResource.append("?versioning=").append(queryParams.get("versioning"));
            }
            if (queryParams.containsKey("versions")) {
                canonicalizedResource.append("?versions");
            }
        }
        return canonicalizedResource.toString();
    }

    public static String canonicalizeAmzHeaders(MultiMap<String, String> customHeaders) {
        StringBuilder ret = new StringBuilder();
        for (Map.Entry<String, Collection<String>> header : customHeaders.entrySet()) {
            String key = header.getKey().toLowerCase();
            if (!key.startsWith("x-amz-meta-") || header.getValue().size() <= 0) continue;
            ret.append(key).append(":");
            ret.append(Joiner.on((String)",").join((Iterable)header.getValue()));
            ret.append('\n');
        }
        return ret.toString();
    }
}

