/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Map;

public class DriveDeleteFeature
implements Delete {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveDeleteFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            if (file.getType().contains(AbstractPath.Type.placeholder)) continue;
            callback.delete(file);
            try {
                if (DriveHomeFinderService.TEAM_DRIVES_NAME.equals((Object)file.getParent())) {
                    ((Drive)this.session.getClient()).teamdrives().delete(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())).execute();
                    continue;
                }
                if (PreferencesFactory.get().getBoolean("googledrive.delete.trash")) {
                    File properties = new File();
                    properties.setTrashed(Boolean.valueOf(true));
                    ((Drive)this.session.getClient()).files().update(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), properties).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
                    continue;
                }
                ((Drive)this.session.getClient()).files().delete(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return !file.getType().contains(AbstractPath.Type.shared);
    }

    public boolean isRecursive() {
        return true;
    }
}

