/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveUrlProvider;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.Permission;
import java.io.IOException;

public class DriveSharingUrlProvider
implements PromptUrlProvider {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveSharingUrlProvider(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return true;
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        Permission permission = new Permission();
        permission.setRole("reader");
        permission.setType("anyone");
        try {
            ((Drive)this.session.getClient()).permissions().create(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), permission).execute();
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        return new DriveUrlProvider().toUrl(file).find(DescriptiveUrl.Type.http);
    }

    public DescriptiveUrl toUploadUrl(Path file, Object options, PasswordCallback callback) throws BackgroundException {
        throw new UnsupportedException();
    }
}

