/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.AuthenticationResponse;
import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class Authentication10ResponseHandler
implements ResponseHandler<AuthenticationResponse> {
    public AuthenticationResponse handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
            return new AuthenticationResponse(response, response.getFirstHeader("X-Auth-Token").getValue(), Collections.singleton(new Region(null, this.getStorageURL(response), this.getCDNManagementURL(response), true)));
        }
        if (response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 403) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }

    private URI getStorageURL(HttpResponse response) {
        Header hdr = response.getFirstHeader("X-Storage-Url");
        if (null == hdr) {
            return null;
        }
        return URI.create(hdr.getValue());
    }

    private URI getCDNManagementURL(HttpResponse response) {
        Header hdr = response.getFirstHeader("X-CDN-Management-URL");
        if (null == hdr) {
            return null;
        }
        return URI.create(hdr.getValue());
    }
}

