/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SearchError {
    public static final SearchError OTHER = new SearchError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathValue;
    private String invalidArgumentValue;

    private SearchError() {
    }

    private SearchError withTag(Tag _tag) {
        SearchError result = new SearchError();
        result._tag = _tag;
        return result;
    }

    private SearchError withTagAndPath(Tag _tag, LookupError pathValue) {
        SearchError result = new SearchError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    private SearchError withTagAndInvalidArgument(Tag _tag, String invalidArgumentValue) {
        SearchError result = new SearchError();
        result._tag = _tag;
        result.invalidArgumentValue = invalidArgumentValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static SearchError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SearchError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isInvalidArgument() {
        return this._tag == Tag.INVALID_ARGUMENT;
    }

    public static SearchError invalidArgument(String value) {
        return new SearchError().withTagAndInvalidArgument(Tag.INVALID_ARGUMENT, value);
    }

    public static SearchError invalidArgument() {
        return SearchError.invalidArgument(null);
    }

    public String getInvalidArgumentValue() {
        if (this._tag != Tag.INVALID_ARGUMENT) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_ARGUMENT, but was Tag." + this._tag.name());
        }
        return this.invalidArgumentValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue, this.invalidArgumentValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SearchError) {
            SearchError other = (SearchError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case INVALID_ARGUMENT: {
                    return this.invalidArgumentValue == other.invalidArgumentValue || this.invalidArgumentValue != null && this.invalidArgumentValue.equals(other.invalidArgumentValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SearchError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case INVALID_ARGUMENT: {
                    g.writeStartObject();
                    this.writeTag("invalid_argument", g);
                    g.writeFieldName("invalid_argument");
                    StoneSerializers.nullable(StoneSerializers.string()).serialize(value.invalidArgumentValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public SearchError deserialize(JsonParser p) throws IOException, JsonParseException {
            SearchError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = SearchError.path(fieldValue);
            } else if ("invalid_argument".equals(tag)) {
                String fieldValue = null;
                if (p.getCurrentToken() != JsonToken.END_OBJECT) {
                    Serializer.expectField("invalid_argument", p);
                    fieldValue = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                }
                value = fieldValue == null ? SearchError.invalidArgument() : SearchError.invalidArgument(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        INVALID_ARGUMENT,
        OTHER;

    }
}

