/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UploadApiRateLimitValue {
    public static final UploadApiRateLimitValue UNLIMITED = new UploadApiRateLimitValue().withTag(Tag.UNLIMITED);
    public static final UploadApiRateLimitValue OTHER = new UploadApiRateLimitValue().withTag(Tag.OTHER);
    private Tag _tag;
    private Long limitValue;

    private UploadApiRateLimitValue() {
    }

    private UploadApiRateLimitValue withTag(Tag _tag) {
        UploadApiRateLimitValue result = new UploadApiRateLimitValue();
        result._tag = _tag;
        return result;
    }

    private UploadApiRateLimitValue withTagAndLimit(Tag _tag, Long limitValue) {
        UploadApiRateLimitValue result = new UploadApiRateLimitValue();
        result._tag = _tag;
        result.limitValue = limitValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUnlimited() {
        return this._tag == Tag.UNLIMITED;
    }

    public boolean isLimit() {
        return this._tag == Tag.LIMIT;
    }

    public static UploadApiRateLimitValue limit(long value) {
        return new UploadApiRateLimitValue().withTagAndLimit(Tag.LIMIT, value);
    }

    public long getLimitValue() {
        if (this._tag != Tag.LIMIT) {
            throw new IllegalStateException("Invalid tag: required Tag.LIMIT, but was Tag." + this._tag.name());
        }
        return this.limitValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.limitValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UploadApiRateLimitValue) {
            UploadApiRateLimitValue other = (UploadApiRateLimitValue)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case UNLIMITED: {
                    return true;
                }
                case LIMIT: {
                    return this.limitValue == other.limitValue;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UploadApiRateLimitValue> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadApiRateLimitValue value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case UNLIMITED: {
                    g.writeString("unlimited");
                    break;
                }
                case LIMIT: {
                    g.writeStartObject();
                    this.writeTag("limit", g);
                    g.writeFieldName("limit");
                    StoneSerializers.uInt32().serialize(value.limitValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public UploadApiRateLimitValue deserialize(JsonParser p) throws IOException, JsonParseException {
            UploadApiRateLimitValue value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("unlimited".equals(tag)) {
                value = UNLIMITED;
            } else if ("limit".equals(tag)) {
                Long fieldValue = null;
                Serializer.expectField("limit", p);
                fieldValue = StoneSerializers.uInt32().deserialize(p);
                value = UploadApiRateLimitValue.limit(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        UNLIMITED,
        LIMIT,
        OTHER;

    }
}

