/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class Name {
    protected final String givenName;
    protected final String surname;
    protected final String familiarName;
    protected final String displayName;
    protected final String abbreviatedName;

    public Name(String givenName, String surname, String familiarName, String displayName, String abbreviatedName) {
        if (givenName == null) {
            throw new IllegalArgumentException("Required value for 'givenName' is null");
        }
        this.givenName = givenName;
        if (surname == null) {
            throw new IllegalArgumentException("Required value for 'surname' is null");
        }
        this.surname = surname;
        if (familiarName == null) {
            throw new IllegalArgumentException("Required value for 'familiarName' is null");
        }
        this.familiarName = familiarName;
        if (displayName == null) {
            throw new IllegalArgumentException("Required value for 'displayName' is null");
        }
        this.displayName = displayName;
        if (abbreviatedName == null) {
            throw new IllegalArgumentException("Required value for 'abbreviatedName' is null");
        }
        this.abbreviatedName = abbreviatedName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getFamiliarName() {
        return this.familiarName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAbbreviatedName() {
        return this.abbreviatedName;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.givenName, this.surname, this.familiarName, this.displayName, this.abbreviatedName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            Name other = (Name)obj;
            return !(this.givenName != other.givenName && !this.givenName.equals(other.givenName) || this.surname != other.surname && !this.surname.equals(other.surname) || this.familiarName != other.familiarName && !this.familiarName.equals(other.familiarName) || this.displayName != other.displayName && !this.displayName.equals(other.displayName) || this.abbreviatedName != other.abbreviatedName && !this.abbreviatedName.equals(other.abbreviatedName));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<Name> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(Name value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("given_name");
            StoneSerializers.string().serialize(value.givenName, g);
            g.writeFieldName("surname");
            StoneSerializers.string().serialize(value.surname, g);
            g.writeFieldName("familiar_name");
            StoneSerializers.string().serialize(value.familiarName, g);
            g.writeFieldName("display_name");
            StoneSerializers.string().serialize(value.displayName, g);
            g.writeFieldName("abbreviated_name");
            StoneSerializers.string().serialize(value.abbreviatedName, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public Name deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_abbreviatedName;
            String f_displayName;
            String f_familiarName;
            String f_surname;
            String f_givenName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_givenName = null;
                f_surname = null;
                f_familiarName = null;
                f_displayName = null;
                f_abbreviatedName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("given_name".equals(field)) {
                        f_givenName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("surname".equals(field)) {
                        f_surname = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("familiar_name".equals(field)) {
                        f_familiarName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("abbreviated_name".equals(field)) {
                        f_abbreviatedName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_givenName == null) {
                    throw new JsonParseException(p, "Required field \"given_name\" missing.");
                }
                if (f_surname == null) {
                    throw new JsonParseException(p, "Required field \"surname\" missing.");
                }
                if (f_familiarName == null) {
                    throw new JsonParseException(p, "Required field \"familiar_name\" missing.");
                }
                if (f_displayName == null) {
                    throw new JsonParseException(p, "Required field \"display_name\" missing.");
                }
                if (f_abbreviatedName == null) {
                    throw new JsonParseException(p, "Required field \"abbreviated_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            Name value = new Name(f_givenName, f_surname, f_familiarName, f_displayName, f_abbreviatedName);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

