/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.manta.MantaAccountHomeInfo;
import ch.cyberduck.core.manta.MantaAttributesFinderFeature;
import ch.cyberduck.core.manta.MantaDeleteFeature;
import ch.cyberduck.core.manta.MantaDirectoryFeature;
import ch.cyberduck.core.manta.MantaExceptionMappingService;
import ch.cyberduck.core.manta.MantaHomeFinderFeature;
import ch.cyberduck.core.manta.MantaHttpExceptionMappingService;
import ch.cyberduck.core.manta.MantaListService;
import ch.cyberduck.core.manta.MantaMoveFeature;
import ch.cyberduck.core.manta.MantaPublicKeyAuthentication;
import ch.cyberduck.core.manta.MantaReadFeature;
import ch.cyberduck.core.manta.MantaSearchFeature;
import ch.cyberduck.core.manta.MantaTouchFeature;
import ch.cyberduck.core.manta.MantaUrlProviderFeature;
import ch.cyberduck.core.manta.MantaWriteFeature;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.config.AuthAwareConfigContext;
import com.joyent.manta.config.ChainedConfigContext;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.DefaultsConfigContext;
import com.joyent.manta.config.StandardConfigContext;
import com.joyent.manta.exception.ConfigurationException;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import com.joyent.manta.http.MantaConnectionFactoryConfigurator;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MantaSession
extends HttpSession<MantaClient> {
    private static final Logger log = Logger.getLogger(MantaSession.class);
    private final AuthAwareConfigContext config;

    public MantaSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
        this.config = new AuthAwareConfigContext((ConfigContext)new ChainedConfigContext(new ConfigContext[]{new DefaultsConfigContext(), new StandardConfigContext().setNoAuth(Boolean.valueOf(true)).setMantaKeyPath(null).setHttpsProtocols(PreferencesFactory.get().getProperty("connection.ssl.protocols")).setDisableNativeSignatures(Boolean.valueOf(true)).setMantaUser(host.getCredentials().getUsername()).setMantaURL(String.format("%s://%s", host.getProtocol().getScheme().name(), host.getHostname()))}));
    }

    protected MantaClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        return new MantaClient((ConfigContext)this.config, new MantaConnectionFactoryConfigurator(this.builder.build(proxy, (TranscriptListener)this, prompt)));
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        try {
            this.config.setMantaUser(this.host.getCredentials().getUsername());
            if (this.host.getCredentials().isPublicKeyAuthentication()) {
                this.config.setMantaKeyId(new MantaPublicKeyAuthentication(this).authenticate(this.host, prompt, cancel));
            } else {
                this.config.setPassword(this.host.getCredentials().getPassword());
            }
            this.config.setNoAuth(Boolean.valueOf(false));
            this.config.reload();
            ((MantaClient)this.client).isDirectoryEmpty(new MantaHomeFinderFeature(this).find().getAbsolute());
        }
        catch (ConfigurationException e) {
            throw new BackgroundException(e.getRawMessage(), (Throwable)e);
        }
        catch (MantaException e) {
            throw new MantaExceptionMappingService().map(e);
        }
        catch (MantaClientHttpResponseException e) {
            throw new MantaHttpExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected void logout() {
        if (this.client != null) {
            ((MantaClient)this.client).closeWithWarning();
        }
    }

    protected boolean userIsOwner() {
        MantaAccountHomeInfo account = new MantaAccountHomeInfo(this.host.getCredentials().getUsername(), this.host.getDefaultPath());
        return StringUtils.equals((CharSequence)this.host.getCredentials().getUsername(), (CharSequence)account.getAccountOwner());
    }

    protected boolean isUserWritable(MantaObject object) {
        MantaAccountHomeInfo account = new MantaAccountHomeInfo(this.host.getCredentials().getUsername(), this.host.getDefaultPath());
        return StringUtils.startsWithAny((CharSequence)object.getPath(), (CharSequence[])new CharSequence[]{account.getAccountPublicRoot().getAbsolute(), account.getAccountPrivateRoot().getAbsolute()});
    }

    protected boolean isUserWritable(Path file) {
        MantaAccountHomeInfo account = new MantaAccountHomeInfo(this.host.getCredentials().getUsername(), this.host.getDefaultPath());
        return file.equals((Object)account.getAccountPublicRoot()) || file.equals((Object)account.getAccountPrivateRoot()) || file.isChild(account.getAccountPublicRoot()) || file.isChild(account.getAccountPrivateRoot());
    }

    protected boolean isWorldReadable(MantaObject object) {
        MantaAccountHomeInfo accountHomeInfo = new MantaAccountHomeInfo(this.host.getCredentials().getUsername(), this.host.getDefaultPath());
        return StringUtils.startsWithAny((CharSequence)object.getPath(), (CharSequence[])new CharSequence[]{accountHomeInfo.getAccountPublicRoot().getAbsolute()});
    }

    protected boolean isWorldReadable(Path file) {
        MantaAccountHomeInfo account = new MantaAccountHomeInfo(this.host.getCredentials().getUsername(), this.host.getDefaultPath());
        return file.isChild(account.getAccountPublicRoot());
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new MantaListService(this);
        }
        if (type == Directory.class) {
            return (T)new MantaDirectoryFeature(this);
        }
        if (type == Read.class) {
            return (T)new MantaReadFeature(this);
        }
        if (type == Write.class) {
            return (T)new MantaWriteFeature(this);
        }
        if (type == Delete.class) {
            return (T)new MantaDeleteFeature(this);
        }
        if (type == Touch.class) {
            return (T)new MantaTouchFeature(this);
        }
        if (type == Move.class) {
            return (T)new MantaMoveFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new MantaAttributesFinderFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new MantaUrlProviderFeature(this);
        }
        if (type == Home.class) {
            return (T)((Object)new MantaHomeFinderFeature(this));
        }
        if (type == Search.class) {
            return (T)new MantaSearchFeature(this);
        }
        return (T)super._getFeature(type);
    }
}

