/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.interfaces;

import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.networking.Headers;
import com.spectralogic.ds3client.networking.Metadata;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.MetadataStringManipulation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MetadataImpl
implements Metadata {
    private static final String X_AMZ_META = "x-amz-meta-";
    private static final String LTFS_METADATA_PREFIX = "x-spectra-ltfs-";
    private final ImmutableMultimap<String, String> metadata;

    public MetadataImpl(Headers headers) {
        this.metadata = MetadataImpl.genMetadata(headers);
    }

    private static ImmutableMultimap<String, String> genMetadata(Headers headers) {
        if (headers == null || Guard.isNullOrEmpty(headers.keys())) {
            return ImmutableMultimap.of();
        }
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        for (String key : headers.keys()) {
            String keyWithoutPrefix = MetadataImpl.metadataKey(key);
            if (keyWithoutPrefix.isEmpty()) continue;
            List<String> values = MetadataImpl.getValues(headers, key);
            mapBuilder.putAll((Object)keyWithoutPrefix, values);
        }
        return mapBuilder.build();
    }

    private static String metadataKey(String key) {
        if (key.startsWith(X_AMZ_META)) {
            return MetadataStringManipulation.toDecodedString(key.substring(X_AMZ_META.length()));
        }
        if (key.startsWith(LTFS_METADATA_PREFIX)) {
            return MetadataStringManipulation.toDecodedString(key.substring(LTFS_METADATA_PREFIX.length()));
        }
        return "";
    }

    private static List<String> getValues(Headers headers, String key) {
        List valueList = headers.get(key);
        ArrayList<String> returnList = new ArrayList<String>(valueList.size());
        for (String valueEntry : valueList) {
            String[] splitEntries;
            for (String splitEntry : splitEntries = valueEntry.split(",")) {
                returnList.add(MetadataStringManipulation.toDecodedString(splitEntry).trim());
            }
        }
        return returnList;
    }

    public List<String> get(String name) {
        String lowerCasedName = MetadataStringManipulation.toDecodedString(MetadataStringManipulation.toEncodedString(name).toLowerCase());
        return this.metadata.get((Object)lowerCasedName).asList();
    }

    public Set<String> keys() {
        return this.metadata.keySet();
    }
}

