/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.DeletedNode;
import ch.cyberduck.core.sds.io.swagger.client.model.DeletedNodeVersionsList;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SDSAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(SDSAttributesFinderFeature.class);
    public static final String KEY_CNT_DOWNLOADSHARES = "count_downloadshares";
    public static final String KEY_CNT_UPLOADSHARES = "count_uploadshares";
    private final PathContainerService containerService = new SDSPathContainerService();
    private final boolean references;
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSAttributesFinderFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this(session, nodeid, PreferencesFactory.get().getBoolean("sds.versioning.references.enable"));
    }

    public SDSAttributesFinderFeature(SDSSession session, SDSNodeIdProvider nodeid, boolean references) {
        this.session = session;
        this.nodeid = nodeid;
        this.references = references;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        return this.find(file, PreferencesFactory.get().getInteger("sds.listing.chunksize"));
    }

    protected PathAttributes find(Path file, int chunksize) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            if (file.attributes().isDuplicate()) {
                DeletedNode node = new NodesApi((ApiClient)this.session.getClient()).getFsDeletedNode(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())), "", null);
                return this.toAttributes(node);
            }
            Node node = new NodesApi((ApiClient)this.session.getClient()).getFsNode(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())), "", null);
            PathAttributes attr = this.toAttributes(node);
            if (this.references) {
                try {
                    attr.setVersions(this.versions(file, chunksize));
                }
                catch (AccessDeniedException e) {
                    log.warn((Object)String.format("Ignore failure %s fetching versions for %s", new Object[]{e, file}));
                }
            }
            return attr;
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    protected AttributedList<Path> versions(Path file, int chunksize) throws BackgroundException {
        try {
            DeletedNodeVersionsList nodes;
            int offset = 0;
            AttributedList versions = new AttributedList();
            do {
                nodes = new NodesApi((ApiClient)this.session.getClient()).getFsDeletedNodeVersions(file.getName(), Long.parseLong(this.nodeid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener())), file.isFile() ? "file" : "folder", "", null, chunksize, offset, null);
                for (DeletedNode item : nodes.getItems()) {
                    versions.add((Referenceable)new Path(file.getParent(), file.getName(), file.getType(), this.toAttributes(item)));
                }
                offset += chunksize;
            } while (nodes.getItems().size() == chunksize);
            return versions;
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(Node node) throws BackgroundException {
        PathAttributes attributes = new PathAttributes();
        attributes.setVersionId(String.valueOf(node.getId()));
        attributes.setRevision(node.getBranchVersion());
        attributes.setChecksum(Checksum.parse((String)node.getHash()));
        attributes.setCreationDate(node.getCreatedAt() != null ? node.getCreatedAt().getMillis() : -1L);
        attributes.setModificationDate(node.getUpdatedAt() != null ? node.getUpdatedAt().getMillis() : -1L);
        attributes.setSize(node.getSize().longValue());
        attributes.setPermission(this.toPermission(node));
        attributes.setOwner(node.getUpdatedBy().getDisplayName());
        attributes.setAcl(this.toAcl(node));
        HashMap<String, String> custom = new HashMap<String, String>();
        if (null != node.getCntDownloadShares()) {
            custom.put(KEY_CNT_DOWNLOADSHARES, String.valueOf(node.getCntDownloadShares()));
        }
        if (null != node.getCntUploadShares()) {
            custom.put(KEY_CNT_UPLOADSHARES, String.valueOf(node.getCntUploadShares()));
        }
        attributes.setCustom(custom);
        return attributes;
    }

    public PathAttributes toAttributes(DeletedNode node) {
        PathAttributes attributes = new PathAttributes();
        attributes.setDuplicate(true);
        attributes.setVersionId(String.valueOf(node.getId()));
        attributes.setCreationDate(node.getCreatedAt() != null ? node.getCreatedAt().getMillis() : -1L);
        attributes.setModificationDate(node.getUpdatedAt() != null ? node.getUpdatedAt().getMillis() : -1L);
        attributes.setSize(node.getSize().longValue());
        attributes.setOwner(node.getUpdatedBy().getDisplayName());
        return attributes;
    }

    public EnumSet<AbstractPath.Type> toType(Node node) {
        EnumSet<AbstractPath.Type> type;
        switch (node.getType()) {
            case ROOM: {
                type = EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume);
                break;
            }
            case FOLDER: {
                type = EnumSet.of(AbstractPath.Type.directory);
                break;
            }
            default: {
                type = EnumSet.of(AbstractPath.Type.file);
            }
        }
        if (node.isIsEncrypted().booleanValue()) {
            type.add(AbstractPath.Type.triplecrypt);
        }
        return type;
    }

    private Permission toPermission(Node node) throws BackgroundException {
        Permission permission = new Permission(Permission.Action.none, Permission.Action.none, Permission.Action.none);
        if (node.isIsEncrypted().booleanValue() && node.getType() == Node.TypeEnum.FILE) {
            if (null != this.session.keyPair()) {
                permission.setUser(permission.getUser().or(Permission.Action.read));
            }
        } else {
            permission.setUser(permission.getUser().or(Permission.Action.read));
        }
        switch (node.getType()) {
            case ROOM: 
            case FOLDER: {
                permission.setUser(permission.getUser().or(Permission.Action.execute));
            }
        }
        if (node.getPermissions().isChange().booleanValue()) {
            permission.setUser(permission.getUser().or(Permission.Action.write));
        }
        return permission;
    }

    private Acl toAcl(Node node) {
        Acl acl = new Acl();
        Acl.CanonicalUser user = new Acl.CanonicalUser();
        if (node.getPermissions().isManage().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.MANAGE_ROLE});
        }
        if (node.getPermissions().isRead().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.READ_ROLE});
        }
        if (node.getPermissions().isCreate().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CREATE_ROLE});
        }
        if (node.getPermissions().isChange().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CHANGE_ROLE});
        }
        if (node.getPermissions().isDelete().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DELETE_ROLE});
        }
        if (node.getPermissions().isManageDownloadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DOWNLOAD_SHARE_ROLE});
        }
        if (node.getPermissions().isManageUploadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.UPLOAD_SHARE_ROLE});
        }
        return acl;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        this.nodeid.withCache((Cache)cache);
        return this;
    }
}

