/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSMissingFileKeysSchedulerFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashMap;
import java.util.Map;

public class SDSEncryptionBulkFeature
implements Bulk<Void> {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSEncryptionBulkFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Void pre(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        switch (type) {
            case download: {
                break;
            }
            default: {
                Map<Path, Boolean> rooms = this.getRoomEncryptionStatus(files);
                for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
                    Path container = new PathContainerService().getContainer(entry.getKey().remote);
                    if (!rooms.get(container).booleanValue()) continue;
                    TransferStatus status = entry.getValue();
                    this.nodeid.setFileKey(status);
                }
            }
        }
        return null;
    }

    private Map<Path, Boolean> getRoomEncryptionStatus(Map<TransferItem, TransferStatus> files) {
        HashMap<Path, Boolean> rooms = new HashMap<Path, Boolean>();
        for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
            Path container = new PathContainerService().getContainer(entry.getKey().remote);
            if (rooms.containsKey(container)) continue;
            rooms.put(container, this.nodeid.isEncrypted(entry.getKey().remote));
        }
        return rooms;
    }

    public void post(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        switch (type) {
            case download: {
                break;
            }
            default: {
                if (!PreferencesFactory.get().getBoolean("sds.encryption.missingkeys.upload") || !this.session.userAccount().isEncryptionEnabled()) break;
                SDSMissingFileKeysSchedulerFeature background = new SDSMissingFileKeysSchedulerFeature();
                Map<Path, Boolean> rooms = this.getRoomEncryptionStatus(files);
                for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
                    VersionId version;
                    Path file = entry.getKey().remote;
                    Path container = new PathContainerService().getContainer(file);
                    if (!rooms.get(container).booleanValue() || null == (version = entry.getValue().getVersion())) continue;
                    background.operate((Session)this.session, (PasswordCallback)callback, file.withAttributes(new PathAttributes(file.attributes()).withVersionId(version.id)));
                }
            }
        }
    }

    public Bulk<Void> withDelete(Delete delete) {
        return this;
    }

    public Bulk<Void> withCache(Cache<Path> cache) {
        this.nodeid.withCache((Cache)cache);
        return this;
    }
}

