/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSWriteFeature;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SDSMultipartWriteFeature
implements MultipartWrite<VersionId> {
    private static final Logger log = Logger.getLogger(SDSMultipartWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Find finder;
    private final AttributesFinder attributes;

    public SDSMultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SDSMultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.nodeid = nodeid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<VersionId> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        String uploadToken = new SDSWriteFeature(this.session, this.nodeid).start(file, status);
        final MultipartOutputStream proxy = new MultipartOutputStream(uploadToken, file, status);
        return new HttpResponseOutputStream<VersionId>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(PreferencesFactory.get().getInteger("sds.upload.multipart.chunksize")))){

            public VersionId getStatus() {
                return proxy.getVersionId();
            }
        };
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final String uploadToken;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<BackgroundException> canceled = new AtomicReference();
        private Long offset = 0L;
        private final Long length;

        public MultipartOutputStream(String uploadToken, Path file, TransferStatus status) {
            this.uploadToken = uploadToken;
            this.file = file;
            this.overall = status;
            this.length = status.getOffset() + status.getLength();
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                final byte[] content = Arrays.copyOfRange(b, off, len);
                final HttpEntity entity = EntityBuilder.create().setBinary(content).build();
                new DefaultRetryCallable(SDSMultipartWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Void call() throws BackgroundException {
                        SDSApiClient client = (SDSApiClient)SDSMultipartWriteFeature.this.session.getClient();
                        try {
                            HttpPost request = new HttpPost(String.format("%s/v4/uploads/%s", client.getBasePath(), MultipartOutputStream.this.uploadToken));
                            request.setEntity(entity);
                            request.setHeader("Content-Type", "application/octet-stream");
                            request.setHeader("X-Sds-Auth-Token", "");
                            if (0L != MultipartOutputStream.this.overall.getLength() && 0 != content.length) {
                                HttpRange range = HttpRange.byLength((long)MultipartOutputStream.this.offset, (long)content.length);
                                String header = MultipartOutputStream.this.overall.getLength() == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), MultipartOutputStream.this.length);
                                request.addHeader("Content-Range", String.format("bytes %s", header));
                            }
                            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
                            try {
                                switch (response.getStatusLine().getStatusCode()) {
                                    case 201: {
                                        MultipartOutputStream.this.offset = MultipartOutputStream.this.offset + (long)content.length;
                                        return null;
                                    }
                                    default: {
                                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                                        throw new SDSExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                                    }
                                }
                            }
                            catch (BackgroundException e) {
                                new SDSWriteFeature(SDSMultipartWriteFeature.this.session, SDSMultipartWriteFeature.this.nodeid).cancel(MultipartOutputStream.this.file, MultipartOutputStream.this.uploadToken);
                                MultipartOutputStream.this.canceled.set(e);
                                throw e;
                            }
                            finally {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                        }
                        catch (IOException e) {
                            throw new DefaultIOExceptionMappingService().map(e);
                        }
                    }
                }, this.overall).call();
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    return;
                }
                try {
                    this.overall.setVersion(new SDSWriteFeature(SDSMultipartWriteFeature.this.session, SDSMultipartWriteFeature.this.nodeid).complete(this.file, this.uploadToken, this.overall));
                }
                catch (ConflictException e) {
                    this.overall.setVersion(new SDSWriteFeature(SDSMultipartWriteFeature.this.session, SDSMultipartWriteFeature.this.nodeid).complete(this.file, this.uploadToken, new TransferStatus(this.overall).exists(true)));
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            finally {
                this.close.set(true);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("id='").append(this.uploadToken).append('\'');
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }

        public VersionId getVersionId() {
            return this.overall.getVersion();
        }
    }
}

