/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConflictException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UploadsApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoSystemException;
import com.dracoon.sdk.crypto.InvalidFileKeyException;
import com.dracoon.sdk.crypto.InvalidKeyPairException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SDSWriteFeature
extends AbstractHttpWriteFeature<VersionId> {
    private static final Logger log = Logger.getLogger(SDSWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Find finder;
    private final AttributesFinder attributes;
    public static final CreateFileUploadRequest.ClassificationEnum DEFAULT_CLASSIFICATION = CreateFileUploadRequest.ClassificationEnum.NUMBER_1;

    public SDSWriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SDSWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.nodeid = nodeid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<VersionId> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        final String uploadToken = this.start(file, status);
        DelayedHttpEntityCallable<VersionId> command = new DelayedHttpEntityCallable<VersionId>(){

            /*
             * Unable to fully structure code
             */
            public VersionId call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    client = (SDSApiClient)SDSWriteFeature.access$000(SDSWriteFeature.this).getClient();
                    request = new HttpPost(String.format("%s/v4/uploads/%s", new Object[]{client.getBasePath(), uploadToken}));
                    request.setEntity((HttpEntity)entity);
                    request.setHeader("Content-Type", "application/octet-stream");
                    request.setHeader("X-Sds-Auth-Token", "");
                    response = client.getClient().execute((HttpUriRequest)request);
                    try {
                        switch (response.getStatusLine().getStatusCode()) {
                            case 201: {
                                ** break;
lbl12:
                                // 1 sources

                                break;
                            }
                            default: {
                                EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                                throw new SDSExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                            }
                        }
                    }
                    catch (BackgroundException e) {
                        SDSWriteFeature.this.cancel(file, uploadToken);
                        throw e;
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                    if (status.isComplete()) {
                        try {
                            version = SDSWriteFeature.this.complete(file, uploadToken, status);
                        }
                        catch (ConflictException e) {
                            version = SDSWriteFeature.this.complete(file, uploadToken, new TransferStatus(status).exists(true));
                        }
                        status.setVersion(version);
                        return version;
                    }
                    SDSWriteFeature.this.cancel(file, uploadToken);
                    return new VersionId(null);
                }
                catch (IOException e) {
                    SDSWriteFeature.this.cancel(file, uploadToken);
                    throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }

    protected String start(Path file, TransferStatus status) throws BackgroundException {
        try {
            CreateFileUploadRequest body = new CreateFileUploadRequest().size(-1L == status.getLength() ? null : Long.valueOf(status.getLength())).parentId(Long.parseLong(this.nodeid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))).name(file.getName());
            CreateFileUploadResponse response = new NodesApi((ApiClient)this.session.getClient()).createFileUpload(body, "");
            return response.getToken();
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    protected VersionId complete(Path file, String uploadToken, TransferStatus status) throws BackgroundException {
        SDSApiClient client = (SDSApiClient)this.session.getClient();
        try {
            Checksum server;
            Checksum checksum;
            Node upload;
            CompleteUploadRequest body = new CompleteUploadRequest().keepShareLinks(status.isExists() ? PreferencesFactory.get().getBoolean("sds.upload.sharelinks.keep") : false).resolutionStrategy(status.isExists() ? CompleteUploadRequest.ResolutionStrategyEnum.OVERWRITE : CompleteUploadRequest.ResolutionStrategyEnum.FAIL);
            if (status.getFilekey() != null) {
                ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                FileKey fileKey = (FileKey)reader.readValue(status.getFilekey().array());
                EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(this.session.keyPair().getPublicKeyContainer()));
                body.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
            }
            if (!(upload = new UploadsApi(client).completeFileUploadByToken(uploadToken, null, body)).isIsEncrypted().booleanValue() && Checksum.NONE != (checksum = status.getChecksum()) && Checksum.NONE != (server = Checksum.parse((String)upload.getHash())) && checksum.algorithm.equals((Object)server.algorithm) && !server.equals((Object)checksum)) {
                throw new ChecksumException(MessageFormat.format(LocaleFactory.localizedString((String)"Upload {0} failed", (String)"Error"), file.getName()), MessageFormat.format("Mismatch between MD5 hash {0} of uploaded data and ETag {1} returned by the server", checksum.hash, server.hash));
            }
            return new VersionId(String.valueOf(upload.getId()));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException e) {
            throw new TripleCryptExceptionMappingService().map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    protected void cancel(Path file, String uploadToken) throws BackgroundException {
        log.warn((Object)String.format("Cancel failed upload %s for %s", uploadToken, file));
        try {
            new UploadsApi((ApiClient)this.session.getClient()).cancelFileUploadByToken(uploadToken);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    public ChecksumCompute checksum(Path file, TransferStatus status) {
        return ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5);
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    static /* synthetic */ SDSSession access$000(SDSWriteFeature x0) {
        return x0.session;
    }
}

