/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.ApiResponse;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.GroupIds;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleGroupList;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleUserList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserIds;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RolesApi {
    private ApiClient apiClient;

    public RolesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RolesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RoleGroupList addRoleGroups(GroupIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        return this.addRoleGroupsWithHttpInfo(body, roleId, xSdsAuthToken).getData();
    }

    public ApiResponse<RoleGroupList> addRoleGroupsWithHttpInfo(GroupIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        GroupIds localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addRoleGroups");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addRoleGroups");
        }
        String localVarPath = "/v4/roles/{role_id}/groups".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleGroupList> localVarReturnType = new GenericType<RoleGroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleUserList addRoleUsers(UserIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        return this.addRoleUsersWithHttpInfo(body, roleId, xSdsAuthToken).getData();
    }

    public ApiResponse<RoleUserList> addRoleUsersWithHttpInfo(UserIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        UserIds localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addRoleUsers");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addRoleUsers");
        }
        String localVarPath = "/v4/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleUserList> localVarReturnType = new GenericType<RoleUserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleGroupList deleteRoleGroups(GroupIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        return this.deleteRoleGroupsWithHttpInfo(body, roleId, xSdsAuthToken).getData();
    }

    public ApiResponse<RoleGroupList> deleteRoleGroupsWithHttpInfo(GroupIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        GroupIds localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteRoleGroups");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRoleGroups");
        }
        String localVarPath = "/v4/roles/{role_id}/groups".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleGroupList> localVarReturnType = new GenericType<RoleGroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleUserList deleteRoleUsers(UserIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        return this.deleteRoleUsersWithHttpInfo(body, roleId, xSdsAuthToken).getData();
    }

    public ApiResponse<RoleUserList> deleteRoleUsersWithHttpInfo(UserIds body, Integer roleId, String xSdsAuthToken) throws ApiException {
        UserIds localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteRoleUsers");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRoleUsers");
        }
        String localVarPath = "/v4/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleUserList> localVarReturnType = new GenericType<RoleUserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleGroupList getRoleGroups(Integer roleId, String xSdsAuthToken, String filter, Integer limit, Integer offset) throws ApiException {
        return this.getRoleGroupsWithHttpInfo(roleId, xSdsAuthToken, filter, limit, offset).getData();
    }

    public ApiResponse<RoleGroupList> getRoleGroupsWithHttpInfo(Integer roleId, String xSdsAuthToken, String filter, Integer limit, Integer offset) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRoleGroups");
        }
        String localVarPath = "/v4/roles/{role_id}/groups".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleGroupList> localVarReturnType = new GenericType<RoleGroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleUserList getRoleUsers(Integer roleId, String xSdsAuthToken, String filter, Integer limit, Integer offset) throws ApiException {
        return this.getRoleUsersWithHttpInfo(roleId, xSdsAuthToken, filter, limit, offset).getData();
    }

    public ApiResponse<RoleUserList> getRoleUsersWithHttpInfo(Integer roleId, String xSdsAuthToken, String filter, Integer limit, Integer offset) throws ApiException {
        Object localVarPostBody = null;
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRoleUsers");
        }
        String localVarPath = "/v4/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleUserList> localVarReturnType = new GenericType<RoleUserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleList getRoles(String xSdsAuthToken) throws ApiException {
        return this.getRolesWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<RoleList> getRolesWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<RoleList> localVarReturnType = new GenericType<RoleList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

