/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.ApiResponse;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.AttributesResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.Avatar;
import ch.cyberduck.core.sds.io.swagger.client.model.ChangeUserPasswordRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CustomerData;
import ch.cyberduck.core.sds.io.swagger.client.model.EnableCustomerEncryptionRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.OAuthAuthorization;
import ch.cyberduck.core.sds.io.swagger.client.model.ProfileAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.ProfileAttributesRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UpdateUserAccountRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAccount;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class UserApi {
    private ApiClient apiClient;

    public UserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Avatar changeAvatar(File file, String xSdsAuthToken) throws ApiException {
        return this.changeAvatarWithHttpInfo(file, xSdsAuthToken).getData();
    }

    public ApiResponse<Avatar> changeAvatarWithHttpInfo(File file, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (file == null) {
            throw new ApiException(400, "Missing the required parameter 'file' when calling changeAvatar");
        }
        String localVarPath = "/v4/user/account/avatar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Avatar> localVarReturnType = new GenericType<Avatar>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void changeUserPassword(ChangeUserPasswordRequest body, String xSdsAuthToken) throws ApiException {
        this.changeUserPasswordWithHttpInfo(body, xSdsAuthToken);
    }

    public ApiResponse<Void> changeUserPasswordWithHttpInfo(ChangeUserPasswordRequest body, String xSdsAuthToken) throws ApiException {
        ChangeUserPasswordRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling changeUserPassword");
        }
        String localVarPath = "/v4/user/account/password";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Avatar deleteAvatar(String xSdsAuthToken) throws ApiException {
        return this.deleteAvatarWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<Avatar> deleteAvatarWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/account/avatar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Avatar> localVarReturnType = new GenericType<Avatar>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteOAuthAuthorization(Long authorizationId, String clientId, String xSdsAuthToken) throws ApiException {
        this.deleteOAuthAuthorizationWithHttpInfo(authorizationId, clientId, xSdsAuthToken);
    }

    public ApiResponse<Void> deleteOAuthAuthorizationWithHttpInfo(Long authorizationId, String clientId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (authorizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'authorizationId' when calling deleteOAuthAuthorization");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling deleteOAuthAuthorization");
        }
        String localVarPath = "/v4/user/oauth/authorizations/{client_id}/{authorization_id}".replaceAll("\\{authorization_id\\}", this.apiClient.escapeString(authorizationId.toString())).replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteOAuthAuthorizations(String clientId, String xSdsAuthToken) throws ApiException {
        this.deleteOAuthAuthorizationsWithHttpInfo(clientId, xSdsAuthToken);
    }

    public ApiResponse<Void> deleteOAuthAuthorizationsWithHttpInfo(String clientId, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling deleteOAuthAuthorizations");
        }
        String localVarPath = "/v4/user/oauth/authorizations/{client_id}".replaceAll("\\{client_id\\}", this.apiClient.escapeString(clientId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteProfileAttribute(String key, String xSdsAuthToken) throws ApiException {
        this.deleteProfileAttributeWithHttpInfo(key, xSdsAuthToken);
    }

    public ApiResponse<Void> deleteProfileAttributeWithHttpInfo(String key, String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteProfileAttribute");
        }
        String localVarPath = "/v4/user/profileAttributes/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteUserKeyPair(String xSdsAuthToken) throws ApiException {
        this.deleteUserKeyPairWithHttpInfo(xSdsAuthToken);
    }

    public ApiResponse<Void> deleteUserKeyPairWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/account/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public CustomerData enableCustomerEncryption(EnableCustomerEncryptionRequest body, String xSdsAuthToken) throws ApiException {
        return this.enableCustomerEncryptionWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<CustomerData> enableCustomerEncryptionWithHttpInfo(EnableCustomerEncryptionRequest body, String xSdsAuthToken) throws ApiException {
        EnableCustomerEncryptionRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling enableCustomerEncryption");
        }
        String localVarPath = "/v4/user/account/customer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<CustomerData> localVarReturnType = new GenericType<CustomerData>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Avatar getAvatar(String xSdsAuthToken) throws ApiException {
        return this.getAvatarWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<Avatar> getAvatarWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/account/avatar";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<Avatar> localVarReturnType = new GenericType<Avatar>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CustomerData getCustomerInfo(String xSdsAuthToken) throws ApiException {
        return this.getCustomerInfoWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<CustomerData> getCustomerInfoWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/account/customer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<CustomerData> localVarReturnType = new GenericType<CustomerData>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserKeyPairContainer getCustomerKeyPair(String xSdsAuthToken) throws ApiException {
        return this.getCustomerKeyPairWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<UserKeyPairContainer> getCustomerKeyPairWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/account/customer/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<UserKeyPairContainer> localVarReturnType = new GenericType<UserKeyPairContainer>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuthAuthorization> getOAuthAuthorizations(String xSdsAuthToken, String xSdsDateFormat, String filter, String sort) throws ApiException {
        return this.getOAuthAuthorizationsWithHttpInfo(xSdsAuthToken, xSdsDateFormat, filter, sort).getData();
    }

    public ApiResponse<List<OAuthAuthorization>> getOAuthAuthorizationsWithHttpInfo(String xSdsAuthToken, String xSdsDateFormat, String filter, String sort) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/oauth/authorizations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<List<OAuthAuthorization>> localVarReturnType = new GenericType<List<OAuthAuthorization>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public AttributesResponse getProfileAttributes(String xSdsAuthToken, String filter, Integer limit, Integer offset, String sort) throws ApiException {
        return this.getProfileAttributesWithHttpInfo(xSdsAuthToken, filter, limit, offset, sort).getData();
    }

    public ApiResponse<AttributesResponse> getProfileAttributesWithHttpInfo(String xSdsAuthToken, String filter, Integer limit, Integer offset, String sort) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/profileAttributes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<AttributesResponse> localVarReturnType = new GenericType<AttributesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserAccount getUserInfo(String xSdsAuthToken, String xSdsDateFormat, Boolean moreInfo) throws ApiException {
        return this.getUserInfoWithHttpInfo(xSdsAuthToken, xSdsDateFormat, moreInfo).getData();
    }

    public ApiResponse<UserAccount> getUserInfoWithHttpInfo(String xSdsAuthToken, String xSdsDateFormat, Boolean moreInfo) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "more_info", moreInfo));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<UserAccount> localVarReturnType = new GenericType<UserAccount>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserKeyPairContainer getUserKeyPair(String xSdsAuthToken) throws ApiException {
        return this.getUserKeyPairWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<UserKeyPairContainer> getUserKeyPairWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/account/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<UserKeyPairContainer> localVarReturnType = new GenericType<UserKeyPairContainer>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Deprecated
    public ProfileAttributes setAllProfileAttributes(ProfileAttributesRequest body, String xSdsAuthToken) throws ApiException {
        return this.setAllProfileAttributesWithHttpInfo(body, xSdsAuthToken).getData();
    }

    @Deprecated
    public ApiResponse<ProfileAttributes> setAllProfileAttributesWithHttpInfo(ProfileAttributesRequest body, String xSdsAuthToken) throws ApiException {
        ProfileAttributesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setAllProfileAttributes");
        }
        String localVarPath = "/v4/user/profileAttributes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<ProfileAttributes> localVarReturnType = new GenericType<ProfileAttributes>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ProfileAttributes setProfileAttributes(ProfileAttributesRequest body, String xSdsAuthToken) throws ApiException {
        return this.setProfileAttributesWithHttpInfo(body, xSdsAuthToken).getData();
    }

    public ApiResponse<ProfileAttributes> setProfileAttributesWithHttpInfo(ProfileAttributesRequest body, String xSdsAuthToken) throws ApiException {
        ProfileAttributesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setProfileAttributes");
        }
        String localVarPath = "/v4/user/profileAttributes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<ProfileAttributes> localVarReturnType = new GenericType<ProfileAttributes>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void setUserKeyPair(UserKeyPairContainer body, String xSdsAuthToken) throws ApiException {
        this.setUserKeyPairWithHttpInfo(body, xSdsAuthToken);
    }

    public ApiResponse<Void> setUserKeyPairWithHttpInfo(UserKeyPairContainer body, String xSdsAuthToken) throws ApiException {
        UserKeyPairContainer localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setUserKeyPair");
        }
        String localVarPath = "/v4/user/account/keypair";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UserAccount updateUserAccount(UpdateUserAccountRequest body, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        return this.updateUserAccountWithHttpInfo(body, xSdsAuthToken, xSdsDateFormat).getData();
    }

    public ApiResponse<UserAccount> updateUserAccountWithHttpInfo(UpdateUserAccountRequest body, String xSdsAuthToken, String xSdsDateFormat) throws ApiException {
        UpdateUserAccountRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateUserAccount");
        }
        String localVarPath = "/v4/user/account";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<UserAccount> localVarReturnType = new GenericType<UserAccount>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Deprecated
    public void userLogout(String xSdsAuthToken, Boolean everywhere) throws ApiException {
        this.userLogoutWithHttpInfo(xSdsAuthToken, everywhere);
    }

    @Deprecated
    public ApiResponse<Void> userLogoutWithHttpInfo(String xSdsAuthToken, Boolean everywhere) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/logout";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "everywhere", everywhere));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public String userPing(String xSdsAuthToken) throws ApiException {
        return this.userPingWithHttpInfo(xSdsAuthToken).getData();
    }

    public ApiResponse<String> userPingWithHttpInfo(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v4/user/ping";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"DRACOON-OAuth"};
        GenericType<String> localVarReturnType = new GenericType<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

