/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateRoomRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="recycleBinRetentionPeriod")
    private Integer recycleBinRetentionPeriod = null;
    @JsonProperty(value="quota")
    private Long quota = null;
    @JsonProperty(value="inheritPermissions")
    private Boolean inheritPermissions = null;
    @JsonProperty(value="adminIds")
    private List<Long> adminIds = null;
    @JsonProperty(value="adminGroupIds")
    private List<Long> adminGroupIds = null;
    @JsonProperty(value="newGroupMemberAcceptance")
    private NewGroupMemberAcceptanceEnum newGroupMemberAcceptance = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="hasActivitiesLog")
    private Boolean hasActivitiesLog = null;
    @JsonProperty(value="classification")
    private ClassificationEnum classification = null;
    @JsonProperty(value="hasRecycleBin")
    private Boolean hasRecycleBin = null;

    public CreateRoomRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateRoomRequest parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(value="Parent room ID or `null` to create a top level room (default: `0`)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public CreateRoomRequest recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
        return this;
    }

    @ApiModelProperty(value="Retention period for deleted nodes in days (Integer between 0 and 9999)")
    public Integer getRecycleBinRetentionPeriod() {
        return this.recycleBinRetentionPeriod;
    }

    public void setRecycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
    }

    public CreateRoomRequest quota(Long quota) {
        this.quota = quota;
        return this;
    }

    @ApiModelProperty(value="Quota in byte")
    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public CreateRoomRequest inheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
        return this;
    }

    @ApiModelProperty(example="false", value="Inherit permissions from parent room (default: `false` if `parentId` is `0`; otherwise: `true`)")
    public Boolean isInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public CreateRoomRequest adminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
        return this;
    }

    public CreateRoomRequest addAdminIdsItem(Long adminIdsItem) {
        if (this.adminIds == null) {
            this.adminIds = new ArrayList<Long>();
        }
        this.adminIds.add(adminIdsItem);
        return this;
    }

    @ApiModelProperty(value="List of user ids A room requires at least one admin (user or group)")
    public List<Long> getAdminIds() {
        return this.adminIds;
    }

    public void setAdminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
    }

    public CreateRoomRequest adminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
        return this;
    }

    public CreateRoomRequest addAdminGroupIdsItem(Long adminGroupIdsItem) {
        if (this.adminGroupIds == null) {
            this.adminGroupIds = new ArrayList<Long>();
        }
        this.adminGroupIds.add(adminGroupIdsItem);
        return this;
    }

    @ApiModelProperty(value="List of group ids A room requires at least one admin (user or group)")
    public List<Long> getAdminGroupIds() {
        return this.adminGroupIds;
    }

    public void setAdminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
    }

    public CreateRoomRequest newGroupMemberAcceptance(NewGroupMemberAcceptanceEnum newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
        return this;
    }

    @ApiModelProperty(example="autoallow", value="Behaviour when new users are added to the group: * `autoallow` * `pending`  Only relevant if `adminGroupIds` has items. (default: `autoallow`)")
    public NewGroupMemberAcceptanceEnum getNewGroupMemberAcceptance() {
        return this.newGroupMemberAcceptance;
    }

    public void setNewGroupMemberAcceptance(NewGroupMemberAcceptanceEnum newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
    }

    public CreateRoomRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="User notes (limited to 255 characters) Use empty string to remove.")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateRoomRequest hasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
        return this;
    }

    @ApiModelProperty(example="true", value="Is activities log active (for rooms only) (default: `true`)")
    public Boolean isHasActivitiesLog() {
        return this.hasActivitiesLog;
    }

    public void setHasActivitiesLog(Boolean hasActivitiesLog) {
        this.hasActivitiesLog = hasActivitiesLog;
    }

    public CreateRoomRequest classification(ClassificationEnum classification) {
        this.classification = classification;
        return this;
    }

    @ApiModelProperty(example="2", value="Classification ID: * `1` - public * `2` - internal * `3` - confidential * `4` - strictly confidential  Provided (or default) classification is taken from room when file gets uploaded without any classification. (default: `2` - internal)")
    public ClassificationEnum getClassification() {
        return this.classification;
    }

    public void setClassification(ClassificationEnum classification) {
        this.classification = classification;
    }

    public CreateRoomRequest hasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
        return this;
    }

    @ApiModelProperty(example="true", value="`DEPRECATED`: Is Recycle Bin active (for rooms only) Recycle Bin is always on (disabling is not possible).")
    public Boolean isHasRecycleBin() {
        return this.hasRecycleBin;
    }

    public void setHasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRoomRequest createRoomRequest = (CreateRoomRequest)o;
        return Objects.equals(this.name, createRoomRequest.name) && Objects.equals(this.parentId, createRoomRequest.parentId) && Objects.equals(this.recycleBinRetentionPeriod, createRoomRequest.recycleBinRetentionPeriod) && Objects.equals(this.quota, createRoomRequest.quota) && Objects.equals(this.inheritPermissions, createRoomRequest.inheritPermissions) && Objects.equals(this.adminIds, createRoomRequest.adminIds) && Objects.equals(this.adminGroupIds, createRoomRequest.adminGroupIds) && Objects.equals((Object)this.newGroupMemberAcceptance, (Object)createRoomRequest.newGroupMemberAcceptance) && Objects.equals(this.notes, createRoomRequest.notes) && Objects.equals(this.hasActivitiesLog, createRoomRequest.hasActivitiesLog) && Objects.equals((Object)this.classification, (Object)createRoomRequest.classification) && Objects.equals(this.hasRecycleBin, createRoomRequest.hasRecycleBin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.parentId, this.recycleBinRetentionPeriod, this.quota, this.inheritPermissions, this.adminIds, this.adminGroupIds, this.newGroupMemberAcceptance, this.notes, this.hasActivitiesLog, this.classification, this.hasRecycleBin});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRoomRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    recycleBinRetentionPeriod: ").append(this.toIndentedString(this.recycleBinRetentionPeriod)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    inheritPermissions: ").append(this.toIndentedString(this.inheritPermissions)).append("\n");
        sb.append("    adminIds: ").append(this.toIndentedString(this.adminIds)).append("\n");
        sb.append("    adminGroupIds: ").append(this.toIndentedString(this.adminGroupIds)).append("\n");
        sb.append("    newGroupMemberAcceptance: ").append(this.toIndentedString((Object)this.newGroupMemberAcceptance)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    hasActivitiesLog: ").append(this.toIndentedString(this.hasActivitiesLog)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString((Object)this.classification)).append("\n");
        sb.append("    hasRecycleBin: ").append(this.toIndentedString(this.hasRecycleBin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ClassificationEnum {
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_3(3),
        NUMBER_4(4);

        private Integer value;

        private ClassificationEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClassificationEnum fromValue(String text) {
            for (ClassificationEnum b : ClassificationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum NewGroupMemberAcceptanceEnum {
        AUTOALLOW("autoallow"),
        PENDING("pending");

        private String value;

        private NewGroupMemberAcceptanceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NewGroupMemberAcceptanceEnum fromValue(String text) {
            for (NewGroupMemberAcceptanceEnum b : NewGroupMemberAcceptanceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

