/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerAttributes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

public class UpdateCustomerResponse {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="companyName")
    private String companyName = null;
    @JsonProperty(value="customerContractType")
    private CustomerContractTypeEnum customerContractType = null;
    @JsonProperty(value="quotaMax")
    private Long quotaMax = null;
    @JsonProperty(value="userMax")
    private Integer userMax = null;
    @JsonProperty(value="lockStatus")
    private Boolean lockStatus = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = null;
    @JsonProperty(value="trialDays")
    private Integer trialDays = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="customerAttributes")
    private CustomerAttributes customerAttributes = null;
    @JsonProperty(value="activationCode")
    private String activationCode = null;
    @JsonProperty(value="providerCustomerId")
    private String providerCustomerId = null;

    public UpdateCustomerResponse id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the customer")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UpdateCustomerResponse companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(required=true, value="Company name")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public UpdateCustomerResponse customerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
        return this;
    }

    @ApiModelProperty(example="pay", required=true, value="Customer type")
    public CustomerContractTypeEnum getCustomerContractType() {
        return this.customerContractType;
    }

    public void setCustomerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
    }

    public UpdateCustomerResponse quotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal disc space which can be allocated by customer in bytes.")
    public Long getQuotaMax() {
        return this.quotaMax;
    }

    public void setQuotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
    }

    public UpdateCustomerResponse userMax(Integer userMax) {
        this.userMax = userMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal number of users")
    public Integer getUserMax() {
        return this.userMax;
    }

    public void setUserMax(Integer userMax) {
        this.userMax = userMax;
    }

    public UpdateCustomerResponse lockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="`DEPRECATED`: Customer lock status: * `false` - unlocked * `true` - locked  Please use `isLocked` instead. All users of this customer will be blocked and can not login anymore. (default: `false`)  [Deprecated since version 4.7.0]")
    public Boolean isLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UpdateCustomerResponse isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @ApiModelProperty(example="false", value="Customer is locked: * `false` - unlocked * `true` - locked  All users of this customer will be blocked and can not login anymore. (default: `false`)")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UpdateCustomerResponse trialDays(Integer trialDays) {
        this.trialDays = trialDays;
        return this;
    }

    @ApiModelProperty(value="Number of days left for trial period (relevant only for type `demo`)")
    public Integer getTrialDays() {
        return this.trialDays;
    }

    public void setTrialDays(Integer trialDays) {
        this.trialDays = trialDays;
    }

    public UpdateCustomerResponse createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UpdateCustomerResponse customerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
        return this;
    }

    @ApiModelProperty(value="Customer attributes")
    public CustomerAttributes getCustomerAttributes() {
        return this.customerAttributes;
    }

    public void setCustomerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
    }

    public UpdateCustomerResponse activationCode(String activationCode) {
        this.activationCode = activationCode;
        return this;
    }

    @ApiModelProperty(value="`DEPRECATED`: Customer activation code string: * valid only for types `free` and `demo` * for `pay` customers it is empty  [Deprecated since version 4.8.0]")
    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public UpdateCustomerResponse providerCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
        return this;
    }

    @ApiModelProperty(value="`DEPRECATED`: Provider customer ID  [Deprecated since version 4.8.0]")
    public String getProviderCustomerId() {
        return this.providerCustomerId;
    }

    public void setProviderCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCustomerResponse updateCustomerResponse = (UpdateCustomerResponse)o;
        return Objects.equals(this.id, updateCustomerResponse.id) && Objects.equals(this.companyName, updateCustomerResponse.companyName) && Objects.equals((Object)this.customerContractType, (Object)updateCustomerResponse.customerContractType) && Objects.equals(this.quotaMax, updateCustomerResponse.quotaMax) && Objects.equals(this.userMax, updateCustomerResponse.userMax) && Objects.equals(this.lockStatus, updateCustomerResponse.lockStatus) && Objects.equals(this.isLocked, updateCustomerResponse.isLocked) && Objects.equals(this.trialDays, updateCustomerResponse.trialDays) && Objects.equals(this.createdAt, updateCustomerResponse.createdAt) && Objects.equals(this.customerAttributes, updateCustomerResponse.customerAttributes) && Objects.equals(this.activationCode, updateCustomerResponse.activationCode) && Objects.equals(this.providerCustomerId, updateCustomerResponse.providerCustomerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.companyName, this.customerContractType, this.quotaMax, this.userMax, this.lockStatus, this.isLocked, this.trialDays, this.createdAt, this.customerAttributes, this.activationCode, this.providerCustomerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateCustomerResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    customerContractType: ").append(this.toIndentedString((Object)this.customerContractType)).append("\n");
        sb.append("    quotaMax: ").append(this.toIndentedString(this.quotaMax)).append("\n");
        sb.append("    userMax: ").append(this.toIndentedString(this.userMax)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    trialDays: ").append(this.toIndentedString(this.trialDays)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    customerAttributes: ").append(this.toIndentedString(this.customerAttributes)).append("\n");
        sb.append("    activationCode: ").append(this.toIndentedString(this.activationCode)).append("\n");
        sb.append("    providerCustomerId: ").append(this.toIndentedString(this.providerCustomerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomerContractTypeEnum {
        FREE("free"),
        DEMO("demo"),
        PAY("pay");

        private String value;

        private CustomerContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomerContractTypeEnum fromValue(String text) {
            for (CustomerContractTypeEnum b : CustomerContractTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

