/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Request model for updating a Download Share")
public class UpdateDownloadShareRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="internalNotes")
    private String internalNotes = null;
    @JsonProperty(value="showCreatorName")
    private Boolean showCreatorName = null;
    @JsonProperty(value="showCreatorUsername")
    private Boolean showCreatorUsername = null;
    @JsonProperty(value="notifyCreator")
    private Boolean notifyCreator = null;
    @JsonProperty(value="maxDownloads")
    private Integer maxDownloads = null;
    @JsonProperty(value="textMessageRecipients")
    private List<String> textMessageRecipients = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;
    @JsonProperty(value="defaultCountry")
    private String defaultCountry = null;
    @JsonProperty(value="resetPassword")
    private Boolean resetPassword = null;
    @JsonProperty(value="resetMaxDownloads")
    private Boolean resetMaxDownloads = null;

    public UpdateDownloadShareRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Alias name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateDownloadShareRequest password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Access password, not allowed for encrypted shares")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UpdateDownloadShareRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(value="Expiration date / time")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public UpdateDownloadShareRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="User notes (limited to 255 characters)")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public UpdateDownloadShareRequest internalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
        return this;
    }

    @ApiModelProperty(value="Internal notes (limited to 255 characters)")
    public String getInternalNotes() {
        return this.internalNotes;
    }

    public void setInternalNotes(String internalNotes) {
        this.internalNotes = internalNotes;
    }

    public UpdateDownloadShareRequest showCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
        return this;
    }

    @ApiModelProperty(value="Show creator first and last name.")
    public Boolean isShowCreatorName() {
        return this.showCreatorName;
    }

    public void setShowCreatorName(Boolean showCreatorName) {
        this.showCreatorName = showCreatorName;
    }

    public UpdateDownloadShareRequest showCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
        return this;
    }

    @ApiModelProperty(value="Show creator email address.")
    public Boolean isShowCreatorUsername() {
        return this.showCreatorUsername;
    }

    public void setShowCreatorUsername(Boolean showCreatorUsername) {
        this.showCreatorUsername = showCreatorUsername;
    }

    public UpdateDownloadShareRequest notifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
        return this;
    }

    @ApiModelProperty(value="Notify creator on every download.")
    public Boolean isNotifyCreator() {
        return this.notifyCreator;
    }

    public void setNotifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
    }

    public UpdateDownloadShareRequest maxDownloads(Integer maxDownloads) {
        this.maxDownloads = maxDownloads;
        return this;
    }

    @ApiModelProperty(value="Max allowed downloads")
    public Integer getMaxDownloads() {
        return this.maxDownloads;
    }

    public void setMaxDownloads(Integer maxDownloads) {
        this.maxDownloads = maxDownloads;
    }

    public UpdateDownloadShareRequest textMessageRecipients(List<String> textMessageRecipients) {
        this.textMessageRecipients = textMessageRecipients;
        return this;
    }

    public UpdateDownloadShareRequest addTextMessageRecipientsItem(String textMessageRecipientsItem) {
        if (this.textMessageRecipients == null) {
            this.textMessageRecipients = new ArrayList<String>();
        }
        this.textMessageRecipients.add(textMessageRecipientsItem);
        return this;
    }

    @ApiModelProperty(value="List of recipient FQTNs E.123 / E.164 Format")
    public List<String> getTextMessageRecipients() {
        return this.textMessageRecipients;
    }

    public void setTextMessageRecipients(List<String> textMessageRecipients) {
        this.textMessageRecipients = textMessageRecipients;
    }

    public UpdateDownloadShareRequest receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @ApiModelProperty(example="de-DE", value="Language tag for messages to receiver")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public UpdateDownloadShareRequest defaultCountry(String defaultCountry) {
        this.defaultCountry = defaultCountry;
        return this;
    }

    @ApiModelProperty(value="Country shorthand symbol (cf. ISO 3166-2)")
    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public void setDefaultCountry(String defaultCountry) {
        this.defaultCountry = defaultCountry;
    }

    public UpdateDownloadShareRequest resetPassword(Boolean resetPassword) {
        this.resetPassword = resetPassword;
        return this;
    }

    @ApiModelProperty(value="Set 'true' to reset 'password' for Download Share.")
    public Boolean isResetPassword() {
        return this.resetPassword;
    }

    public void setResetPassword(Boolean resetPassword) {
        this.resetPassword = resetPassword;
    }

    public UpdateDownloadShareRequest resetMaxDownloads(Boolean resetMaxDownloads) {
        this.resetMaxDownloads = resetMaxDownloads;
        return this;
    }

    @ApiModelProperty(value="Set 'true' to reset 'maxDownloads' for Download Share.")
    public Boolean isResetMaxDownloads() {
        return this.resetMaxDownloads;
    }

    public void setResetMaxDownloads(Boolean resetMaxDownloads) {
        this.resetMaxDownloads = resetMaxDownloads;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateDownloadShareRequest updateDownloadShareRequest = (UpdateDownloadShareRequest)o;
        return Objects.equals(this.name, updateDownloadShareRequest.name) && Objects.equals(this.password, updateDownloadShareRequest.password) && Objects.equals(this.expiration, updateDownloadShareRequest.expiration) && Objects.equals(this.notes, updateDownloadShareRequest.notes) && Objects.equals(this.internalNotes, updateDownloadShareRequest.internalNotes) && Objects.equals(this.showCreatorName, updateDownloadShareRequest.showCreatorName) && Objects.equals(this.showCreatorUsername, updateDownloadShareRequest.showCreatorUsername) && Objects.equals(this.notifyCreator, updateDownloadShareRequest.notifyCreator) && Objects.equals(this.maxDownloads, updateDownloadShareRequest.maxDownloads) && Objects.equals(this.textMessageRecipients, updateDownloadShareRequest.textMessageRecipients) && Objects.equals(this.receiverLanguage, updateDownloadShareRequest.receiverLanguage) && Objects.equals(this.defaultCountry, updateDownloadShareRequest.defaultCountry) && Objects.equals(this.resetPassword, updateDownloadShareRequest.resetPassword) && Objects.equals(this.resetMaxDownloads, updateDownloadShareRequest.resetMaxDownloads);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.password, this.expiration, this.notes, this.internalNotes, this.showCreatorName, this.showCreatorUsername, this.notifyCreator, this.maxDownloads, this.textMessageRecipients, this.receiverLanguage, this.defaultCountry, this.resetPassword, this.resetMaxDownloads);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateDownloadShareRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    internalNotes: ").append(this.toIndentedString(this.internalNotes)).append("\n");
        sb.append("    showCreatorName: ").append(this.toIndentedString(this.showCreatorName)).append("\n");
        sb.append("    showCreatorUsername: ").append(this.toIndentedString(this.showCreatorUsername)).append("\n");
        sb.append("    notifyCreator: ").append(this.toIndentedString(this.notifyCreator)).append("\n");
        sb.append("    maxDownloads: ").append(this.toIndentedString(this.maxDownloads)).append("\n");
        sb.append("    textMessageRecipients: ").append(this.toIndentedString(this.textMessageRecipients)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("    defaultCountry: ").append(this.toIndentedString(this.defaultCountry)).append("\n");
        sb.append("    resetPassword: ").append(this.toIndentedString(this.resetPassword)).append("\n");
        sb.append("    resetMaxDownloads: ").append(this.toIndentedString(this.resetMaxDownloads)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

