/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiClient;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.api.FilesApi;
import ch.cyberduck.core.storegate.io.swagger.client.model.RootFolder;
import java.util.HashMap;

public class StoregateIdProvider
implements IdProvider {
    public static final String KEY_NODE_ID = "node_id";
    private final StoregateSession session;

    public StoregateIdProvider(StoregateSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        try {
            if (file.attributes().getCustom().containsKey(KEY_NODE_ID)) {
                return (String)file.attributes().getCustom().get(KEY_NODE_ID);
            }
            String id = new FilesApi((ApiClient)this.session.getClient()).filesGet_1(URIEncoder.encode((String)this.getPrefixedPath(file))).getId();
            HashMap<String, String> custom = new HashMap<String, String>(file.attributes().getCustom());
            custom.put(KEY_NODE_ID, id);
            file.attributes().setCustom(custom);
            return id;
        }
        catch (ApiException e) {
            throw new StoregateExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public StoregateIdProvider withCache(Cache<Path> cache) {
        return this;
    }

    protected String getPrefixedPath(Path file) {
        PathContainerService service = new PathContainerService();
        String root = service.getContainer(file).getAbsolute();
        for (RootFolder r : this.session.roots()) {
            if (!root.endsWith(r.getName())) continue;
            if (service.isContainer(file)) {
                return r.getPath();
            }
            return String.format("%s/%s", r.getPath(), PathRelativizer.relativize((String)root, (String)file.getAbsolute()));
        }
        return file.getAbsolute();
    }
}

