/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.MoveFileRequest;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class StoregateMoveFeature
implements Move {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;

    public StoregateMoveFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback delete, ConnectionCallback callback) throws BackgroundException {
        try {
            StoregateApiClient client = (StoregateApiClient)this.session.getClient();
            MoveFileRequest move = new MoveFileRequest().name(renamed.getName()).parentID(this.fileid.getFileid(renamed.getParent(), (ListProgressListener)new DisabledListProgressListener())).mode(MoveFileRequest.ModeEnum.NUMBER_1);
            HttpPost request = new HttpPost(String.format("%s/v4/files/%s/move", client.getBasePath(), this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())));
            if (status.getLockId() != null) {
                request.addHeader("X-Lock-Id", status.getLockId().toString());
            }
            request.setEntity((HttpEntity)new StringEntity(new JSON().getContext(move.getClass()).writeValueAsString((Object)move), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name())));
            request.addHeader("Content-Type", "application/json; charset=UTF-8");
            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
            try {
                switch (response.getStatusLine().getStatusCode()) {
                    case 204: {
                        Path path = new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new PathAttributes(renamed.attributes()));
                        return path;
                    }
                }
                throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }
}

