/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="A file version.")
public class FileVersion {
    @JsonProperty(value="version")
    private Integer version = null;
    @JsonProperty(value="uploadedBy")
    private String uploadedBy = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="created")
    private DateTime created = null;
    @JsonProperty(value="modified")
    private DateTime modified = null;
    @JsonProperty(value="uploaded")
    private DateTime uploaded = null;
    @JsonProperty(value="accessed")
    private DateTime accessed = null;
    @JsonProperty(value="flags")
    private FlagsEnum flags = null;
    @JsonProperty(value="ownerId")
    private String ownerId = null;

    public FileVersion version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Indicates the file version.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public FileVersion uploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
        return this;
    }

    @ApiModelProperty(value="Uploaded by user")
    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public FileVersion id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The item id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FileVersion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The item name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FileVersion size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="The item size.")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public FileVersion created(DateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was created.")
    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public FileVersion modified(DateTime modified) {
        this.modified = modified;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was last modified.")
    public DateTime getModified() {
        return this.modified;
    }

    public void setModified(DateTime modified) {
        this.modified = modified;
    }

    public FileVersion uploaded(DateTime uploaded) {
        this.uploaded = uploaded;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was uploaded.")
    public DateTime getUploaded() {
        return this.uploaded;
    }

    public void setUploaded(DateTime uploaded) {
        this.uploaded = uploaded;
    }

    public FileVersion accessed(DateTime accessed) {
        this.accessed = accessed;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was last accessed.")
    public DateTime getAccessed() {
        return this.accessed;
    }

    public void setAccessed(DateTime accessed) {
        this.accessed = accessed;
    }

    public FileVersion flags(FlagsEnum flags) {
        this.flags = flags;
        return this;
    }

    @ApiModelProperty(value="Indicates the item type.")
    public FlagsEnum getFlags() {
        return this.flags;
    }

    public void setFlags(FlagsEnum flags) {
        this.flags = flags;
    }

    public FileVersion ownerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @ApiModelProperty(value="The owner.")
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileVersion fileVersion = (FileVersion)o;
        return Objects.equals(this.version, fileVersion.version) && Objects.equals(this.uploadedBy, fileVersion.uploadedBy) && Objects.equals(this.id, fileVersion.id) && Objects.equals(this.name, fileVersion.name) && Objects.equals(this.size, fileVersion.size) && Objects.equals(this.created, fileVersion.created) && Objects.equals(this.modified, fileVersion.modified) && Objects.equals(this.uploaded, fileVersion.uploaded) && Objects.equals(this.accessed, fileVersion.accessed) && Objects.equals((Object)this.flags, (Object)fileVersion.flags) && Objects.equals(this.ownerId, fileVersion.ownerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.uploadedBy, this.id, this.name, this.size, this.created, this.modified, this.uploaded, this.accessed, this.flags, this.ownerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileVersion {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    uploadedBy: ").append(this.toIndentedString(this.uploadedBy)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    uploaded: ").append(this.toIndentedString(this.uploaded)).append("\n");
        sb.append("    accessed: ").append(this.toIndentedString(this.accessed)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString((Object)this.flags)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FlagsEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_4(4),
        NUMBER_8(8),
        NUMBER_16(16),
        NUMBER_32(32),
        NUMBER_64(64),
        NUMBER_128(128),
        NUMBER_256(256),
        NUMBER_512(512);

        private Integer value;

        private FlagsEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FlagsEnum fromValue(String text) {
            for (FlagsEnum b : FlagsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

