/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="A rootfolder is folder that contains part of the account. An account usally have multiple root folders, like \"home\" and \"backup\".")
public class RootFolder {
    @JsonProperty(value="path")
    private String path = null;
    @JsonProperty(value="rootFolderType")
    private RootFolderTypeEnum rootFolderType = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="created")
    private DateTime created = null;
    @JsonProperty(value="modified")
    private DateTime modified = null;
    @JsonProperty(value="uploaded")
    private DateTime uploaded = null;
    @JsonProperty(value="accessed")
    private DateTime accessed = null;
    @JsonProperty(value="flags")
    private FlagsEnum flags = null;
    @JsonProperty(value="ownerId")
    private String ownerId = null;

    public RootFolder path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="The path to the rootfolder.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RootFolder rootFolderType(RootFolderTypeEnum rootFolderType) {
        this.rootFolderType = rootFolderType;
        return this;
    }

    @ApiModelProperty(value="The rootfolder type.")
    public RootFolderTypeEnum getRootFolderType() {
        return this.rootFolderType;
    }

    public void setRootFolderType(RootFolderTypeEnum rootFolderType) {
        this.rootFolderType = rootFolderType;
    }

    public RootFolder id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The item id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RootFolder name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The item name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RootFolder size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="The item size.")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public RootFolder created(DateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was created.")
    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public RootFolder modified(DateTime modified) {
        this.modified = modified;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was last modified.")
    public DateTime getModified() {
        return this.modified;
    }

    public void setModified(DateTime modified) {
        this.modified = modified;
    }

    public RootFolder uploaded(DateTime uploaded) {
        this.uploaded = uploaded;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was uploaded.")
    public DateTime getUploaded() {
        return this.uploaded;
    }

    public void setUploaded(DateTime uploaded) {
        this.uploaded = uploaded;
    }

    public RootFolder accessed(DateTime accessed) {
        this.accessed = accessed;
        return this;
    }

    @ApiModelProperty(value="The date and time the item was last accessed.")
    public DateTime getAccessed() {
        return this.accessed;
    }

    public void setAccessed(DateTime accessed) {
        this.accessed = accessed;
    }

    public RootFolder flags(FlagsEnum flags) {
        this.flags = flags;
        return this;
    }

    @ApiModelProperty(value="Indicates the item type.")
    public FlagsEnum getFlags() {
        return this.flags;
    }

    public void setFlags(FlagsEnum flags) {
        this.flags = flags;
    }

    public RootFolder ownerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @ApiModelProperty(value="The owner.")
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootFolder rootFolder = (RootFolder)o;
        return Objects.equals(this.path, rootFolder.path) && Objects.equals((Object)this.rootFolderType, (Object)rootFolder.rootFolderType) && Objects.equals(this.id, rootFolder.id) && Objects.equals(this.name, rootFolder.name) && Objects.equals(this.size, rootFolder.size) && Objects.equals(this.created, rootFolder.created) && Objects.equals(this.modified, rootFolder.modified) && Objects.equals(this.uploaded, rootFolder.uploaded) && Objects.equals(this.accessed, rootFolder.accessed) && Objects.equals((Object)this.flags, (Object)rootFolder.flags) && Objects.equals(this.ownerId, rootFolder.ownerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.rootFolderType, this.id, this.name, this.size, this.created, this.modified, this.uploaded, this.accessed, this.flags, this.ownerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RootFolder {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    rootFolderType: ").append(this.toIndentedString((Object)this.rootFolderType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    uploaded: ").append(this.toIndentedString(this.uploaded)).append("\n");
        sb.append("    accessed: ").append(this.toIndentedString(this.accessed)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString((Object)this.flags)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FlagsEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2),
        NUMBER_4(4),
        NUMBER_8(8),
        NUMBER_16(16),
        NUMBER_32(32),
        NUMBER_64(64),
        NUMBER_128(128),
        NUMBER_256(256),
        NUMBER_512(512);

        private Integer value;

        private FlagsEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FlagsEnum fromValue(String text) {
            for (FlagsEnum b : FlagsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum RootFolderTypeEnum {
        NUMBER_0(0),
        NUMBER_1(1),
        NUMBER_2(2);

        private Integer value;

        private RootFolderTypeEnum(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RootFolderTypeEnum fromValue(String text) {
            for (RootFolderTypeEnum b : RootFolderTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

