/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.putty;

import ch.cyberduck.core.sftp.auth.AgentAuthenticator;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;

public class PageantAuthenticator
extends AgentAuthenticator {
    private static final Logger log = Logger.getLogger(PageantAuthenticator.class);
    private AgentProxy proxy;

    public PageantAuthenticator() {
        try {
            this.proxy = new AgentProxy((Connector)new PageantConnector());
        }
        catch (AgentProxyException e) {
            log.warn((Object)String.format("Agent proxy %s failed with %s", new Object[]{this, e}));
        }
    }

    @Override
    public AgentProxy getProxy() {
        return this.proxy;
    }

    @Override
    public Collection<Identity> getIdentities() {
        if (!PageantConnector.isConnectorAvailable()) {
            log.warn((Object)String.format("Disabled agent %s", this));
            return Collections.emptyList();
        }
        if (null == this.proxy) {
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Retrieve identities from proxy %s", this.proxy));
        }
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Found %d identities", identities.size()));
        }
        try {
            Collections.addAll(identities, this.proxy.getIdentities());
        }
        catch (Exception e) {
            log.warn((Object)String.format("Ignore failure reading identities from %s", this.proxy));
        }
        return identities;
    }
}

