/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSMutableParagraphStyle;
import ch.cyberduck.binding.application.NSParagraphStyle;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextView;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.FactoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class BundleController
extends ProxyController {
    private static final Logger log = Logger.getLogger(BundleController.class);
    public static final NSMutableParagraphStyle PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE = NSMutableParagraphStyle.paragraphStyle();
    public static final NSMutableParagraphStyle PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL;
    public static final NSMutableParagraphStyle PARAGRAPH_STYLE_RIGHT_ALIGNMENT_TRUNCATE_TAIL;
    public static final NSDictionary TRUNCATE_MIDDLE_ATTRIBUTES;
    public static final NSDictionary TRUNCATE_TAIL_ATTRIBUTES;
    public static final NSDictionary MENU_HELP_FONT_ATTRIBUTES;
    protected boolean awaked;

    public void loadBundle() {
        String bundleName = this.getBundleName();
        if (null == bundleName) {
            log.debug((Object)String.format("No bundle to load for controller %s", ((Object)((Object)this)).toString()));
            return;
        }
        this.loadBundle(bundleName);
    }

    public void loadBundle(String bundleName) {
        if (this.awaked) {
            log.warn((Object)String.format("Bundle %s already loaded", bundleName));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Loading bundle %s", bundleName));
        }
        if (!NSBundle.loadNibNamed(bundleName, this.id())) {
            throw new FactoryException(String.format("Failure loading %s.xib", bundleName));
        }
        if (!this.awaked) {
            this.awakeFromNib();
        }
    }

    public void awakeFromNib() {
        log.debug((Object)"awakeFromNib");
        this.awaked = true;
    }

    protected NSView view() {
        return null;
    }

    protected abstract String getBundleName();

    protected void updateField(NSTextView f, String value) {
        if (null == f) {
            return;
        }
        f.setString(StringUtils.isNotBlank((CharSequence)value) ? value : "");
    }

    protected void updateField(NSTextField f, String value) {
        if (null == f) {
            return;
        }
        f.setStringValue(StringUtils.isNotBlank((CharSequence)value) ? value : "");
    }

    protected void updateField(NSTextField f, String value, NSDictionary attributes) {
        if (null == f) {
            return;
        }
        f.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes(StringUtils.isNotBlank((CharSequence)value) ? value : "", attributes));
    }

    static {
        PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE.setParagraphStyle(NSParagraphStyle.defaultParagraphStyle());
        PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE.setAlignment(0);
        PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE.setLineBreakMode(5);
        PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL = NSMutableParagraphStyle.paragraphStyle();
        PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL.setParagraphStyle(NSParagraphStyle.defaultParagraphStyle());
        PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL.setAlignment(0);
        PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_TAIL.setLineBreakMode(4);
        PARAGRAPH_STYLE_RIGHT_ALIGNMENT_TRUNCATE_TAIL = NSMutableParagraphStyle.paragraphStyle();
        PARAGRAPH_STYLE_RIGHT_ALIGNMENT_TRUNCATE_TAIL.setParagraphStyle(NSParagraphStyle.defaultParagraphStyle());
        PARAGRAPH_STYLE_RIGHT_ALIGNMENT_TRUNCATE_TAIL.setAlignment(1);
        PARAGRAPH_STYLE_RIGHT_ALIGNMENT_TRUNCATE_TAIL.setLineBreakMode(4);
        TRUNCATE_MIDDLE_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE), NSArray.arrayWithObject("NSParagraphStyle"));
        TRUNCATE_TAIL_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObject(PARAGRAPH_STYLE_RIGHT_ALIGNMENT_TRUNCATE_TAIL), NSArray.arrayWithObject("NSParagraphStyle"));
        MENU_HELP_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys(NSArray.arrayWithObjects(NSFont.menuFontOfSize(NSFont.smallSystemFontSize()), PARAGRAPH_STYLE_LEFT_ALIGNMENT_TRUNCATE_MIDDLE, NSColor.systemGrayColor()), NSArray.arrayWithObjects("NSFont", "NSParagraphStyle", "NSColor"));
    }
}

