/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSTabView;
import ch.cyberduck.binding.application.NSTabViewItem;
import ch.cyberduck.binding.application.NSToolbar;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.FoundationKitFunctions;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public abstract class ToolbarWindowController
extends WindowController
implements NSToolbar.Delegate,
NSTabView.Delegate {
    private static final Logger log = Logger.getLogger(ToolbarWindowController.class);
    private final Preferences preferences = PreferencesFactory.get();
    private String title;
    protected NSTabView tabView;
    private final NSToolbar toolbar = NSToolbar.toolbarWithIdentifier(this.getToolbarName());
    private final Map<String, NSToolbarItem> cache = new HashMap<String, NSToolbarItem>();

    protected abstract Map<Label, NSView> getPanels();

    @Override
    public void windowDidBecomeKey(NSNotification notification) {
        this.resize();
        super.windowDidBecomeKey(notification);
    }

    public void setTabView(NSTabView view) {
        this.tabView = view;
        this.tabView.setAutoresizingMask(new NSUInteger(18L));
        this.tabView.setDelegate(this.id());
    }

    @Override
    public void awakeFromNib() {
        NSObject object;
        NSEnumerator items = this.tabView.tabViewItems().objectEnumerator();
        while ((object = items.nextObject()) != null) {
            this.tabView.removeTabViewItem((NSTabViewItem)Rococoa.cast((ObjCObject)object, NSTabViewItem.class));
        }
        for (Map.Entry<Label, NSView> tab : this.getPanels().entrySet()) {
            NSTabViewItem item = NSTabViewItem.itemWithIdentifier(tab.getKey().identifier);
            item.setView(tab.getValue());
            item.setLabel(tab.getKey().label);
            this.tabView.addTabViewItem(item);
        }
        this.toolbar.setAllowsUserCustomization(false);
        this.toolbar.setSizeMode(this.getToolbarSize());
        this.toolbar.setDisplayMode(this.getToolbarMode());
        this.toolbar.setDelegate(this.id());
        this.window.setToolbar(this.toolbar);
        int index = this.preferences.getInteger(String.format("%s.selected", this.getToolbarName()));
        this.setSelectedPanel(index < this.getPanels().size() ? index : 0);
        this.setTitle(this.getTitle(this.tabView.selectedTabViewItem()));
        super.awakeFromNib();
    }

    protected void setSelectedPanel(int selected) {
        String identifier;
        int tab = selected;
        if (-1 == tab) {
            tab = 0;
        }
        if (!this.validateTabWithIdentifier(identifier = this.tabView.tabViewItemAtIndex(tab).identifier())) {
            tab = 0;
            identifier = this.tabView.tabViewItemAtIndex(tab).identifier();
        }
        this.tabView.selectTabViewItemAtIndex(tab);
        NSTabViewItem page = this.tabView.selectedTabViewItem();
        if (page == null) {
            page = this.tabView.tabViewItemAtIndex(0);
        }
        this.toolbar.setSelectedItemIdentifier(page.identifier());
        this.initializePanel(identifier);
    }

    protected abstract void initializePanel(String var1);

    protected String getSelectedTab() {
        return this.toolbar.selectedItemIdentifier();
    }

    @Override
    public void invalidate() {
        this.toolbar.setDelegate(null);
        this.tabView.setDelegate(null);
        super.invalidate();
    }

    @Override
    public void setWindow(NSWindow window) {
        this.title = window.title();
        window.setShowsToolbarButton(false);
        super.setWindow(window);
    }

    protected NSUInteger getToolbarSize() {
        return NSToolbar.NSToolbarSizeModeRegular;
    }

    protected NSUInteger getToolbarMode() {
        return NSToolbar.NSToolbarDisplayModeIconAndLabel;
    }

    private String getToolbarName() {
        return String.format("%s.toolbar", this.getBundleName().toLowerCase(Locale.ROOT));
    }

    @Override
    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String itemIdentifier, boolean flag) {
        if (!this.cache.containsKey(itemIdentifier)) {
            this.cache.put(itemIdentifier, NSToolbarItem.itemWithIdentifier(itemIdentifier));
        }
        NSToolbarItem toolbarItem = this.cache.get(itemIdentifier);
        NSTabViewItem tab = this.tabView.tabViewItemAtIndex(this.tabView.indexOfTabViewItemWithIdentifier(itemIdentifier));
        if (null == tab) {
            log.warn((Object)String.format("No tab for toolbar item %s", itemIdentifier));
            return null;
        }
        toolbarItem.setLabel(tab.label());
        toolbarItem.setPaletteLabel(tab.label());
        toolbarItem.setToolTip(tab.label());
        toolbarItem.setImage((NSImage)IconCacheFactory.get().iconNamed(String.format("%s.tiff", itemIdentifier), Integer.valueOf(32)));
        toolbarItem.setTarget(this.id());
        toolbarItem.setAction(Foundation.selector((String)"toolbarItemSelected:"));
        return toolbarItem;
    }

    @Override
    public NSArray toolbarAllowedItemIdentifiers(NSToolbar toolbar) {
        NSMutableArray identifiers = NSMutableArray.array();
        for (Label label : this.getPanels().keySet()) {
            identifiers.addObject(label.identifier);
        }
        return identifiers;
    }

    @Override
    public NSArray toolbarDefaultItemIdentifiers(NSToolbar toolbar) {
        return this.toolbarAllowedItemIdentifiers(toolbar);
    }

    @Override
    public NSArray toolbarSelectableItemIdentifiers(NSToolbar toolbar) {
        return this.toolbarAllowedItemIdentifiers(toolbar);
    }

    @Override
    public boolean validateToolbarItem(NSToolbarItem item) {
        return this.validateTabWithIdentifier(item.itemIdentifier());
    }

    protected boolean validateTabWithIdentifier(String itemIdentifier) {
        return true;
    }

    protected String getTitle(NSTabViewItem item) {
        return item.label();
    }

    public void toolbarItemSelected(NSToolbarItem sender) {
        this.setSelectedPanel(this.tabView.indexOfTabViewItemWithIdentifier(sender.itemIdentifier()));
    }

    private void resize() {
        NSRect windowFrame = NSWindow.contentRectForFrameRect_styleMask(this.window.frame(), this.window.styleMask());
        double height = this.getMinWindowHeight();
        NSRect frameRect = new NSRect(new NSPoint(windowFrame.origin.x.doubleValue(), windowFrame.origin.y.doubleValue() + windowFrame.size.height.doubleValue() - height), new NSSize(windowFrame.size.width.doubleValue(), height));
        this.window.setFrame_display_animate(NSWindow.frameRectForContentRect_styleMask(frameRect, this.window.styleMask()), true, this.window.isVisible());
    }

    public NSSize windowWillResize_toSize(NSWindow window, NSSize newSize) {
        return new NSSize(newSize.width.doubleValue(), window.frame().size.height.doubleValue());
    }

    private double toolbarHeightForWindow(NSWindow window) {
        NSRect windowFrame = NSWindow.contentRectForFrameRect_styleMask(window.frame(), window.styleMask());
        return windowFrame.size.height.doubleValue() - window.contentView().frame().size.height.doubleValue();
    }

    @Override
    public void tabView_didSelectTabViewItem(NSTabView view, NSTabViewItem item) {
        if (this.awaked) {
            this.setTitle(this.getTitle(item));
            this.resize();
            this.preferences.setProperty(String.format("%s.selected", this.getToolbarName()), view.indexOfTabViewItem(item));
        }
    }

    protected void setTitle(String title) {
        this.window.setTitle(String.format("%s \u2013 %s", this.title, title));
    }

    protected double getMinWindowHeight() {
        NSRect contentRect = this.getContentRect();
        return contentRect.size.height.doubleValue() + 40.0 + this.toolbarHeightForWindow(this.window);
    }

    protected double getMinWindowWidth() {
        NSRect contentRect = this.getContentRect();
        return contentRect.size.width.doubleValue();
    }

    private NSRect getContentRect() {
        NSObject next;
        NSRect contentRect = new NSRect(0.0, 0.0);
        NSView view = this.tabView.selectedTabViewItem().view();
        NSEnumerator enumerator = view.subviews().objectEnumerator();
        while (null != (next = enumerator.nextObject())) {
            NSView subview = (NSView)Rococoa.cast((ObjCObject)next, NSView.class);
            contentRect = FoundationKitFunctions.library.NSUnionRect(contentRect, subview.frame());
        }
        return contentRect;
    }

    protected static final class Label {
        public String identifier;
        public String label;

        public Label(String identifier, String label) {
            this.identifier = identifier;
            this.label = label;
        }
    }
}

