/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.onedrive.AbstractListService;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.webloc.UrlFileWriter;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import java.util.EnumSet;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDriveRemoteItem;

public abstract class AbstractItemListService
extends AbstractListService<OneDriveItem.Metadata> {
    private final GraphAttributesFinderFeature attributes;
    private final UrlFileWriter urlFileWriter = UrlFileWriterFactory.get();

    public AbstractItemListService(GraphAttributesFinderFeature attributes) {
        this.attributes = attributes;
    }

    @Override
    protected Path toPath(OneDriveItem.Metadata metadata, Path directory) {
        PathAttributes attr = this.attributes.toAttributes(metadata);
        String fileName = metadata instanceof OneDrivePackageItem.Metadata ? String.format("%s.%s", PathNormalizer.name((String)metadata.getName()), this.urlFileWriter.getExtension()) : metadata.getName();
        return new Path(directory, fileName, this.resolveType(metadata), attr);
    }

    public ListService withCache(Cache<Path> cache) {
        this.attributes.withCache(cache);
        return this;
    }

    private EnumSet<AbstractPath.Type> resolveType(OneDriveItem.Metadata metadata) {
        if (metadata instanceof OneDrivePackageItem.Metadata) {
            return EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.placeholder);
        }
        if (metadata instanceof OneDriveRemoteItem.Metadata) {
            EnumSet<AbstractPath.Type> types = this.resolveType(((OneDriveRemoteItem.Metadata)metadata).getRemoteItem());
            types.add(AbstractPath.Type.shared);
            return types;
        }
        return EnumSet.of(metadata.isFolder() ? AbstractPath.Type.directory : AbstractPath.Type.file);
    }
}

