/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.onedrive.GraphCommonsHttpRequestExecutor;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphBufferWriteFeature;
import ch.cyberduck.core.onedrive.features.GraphCopyFeature;
import ch.cyberduck.core.onedrive.features.GraphDeleteFeature;
import ch.cyberduck.core.onedrive.features.GraphDirectoryFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.onedrive.features.GraphFindFeature;
import ch.cyberduck.core.onedrive.features.GraphMoveFeature;
import ch.cyberduck.core.onedrive.features.GraphQuotaFeature;
import ch.cyberduck.core.onedrive.features.GraphReadFeature;
import ch.cyberduck.core.onedrive.features.GraphSearchFeature;
import ch.cyberduck.core.onedrive.features.GraphTimestampFeature;
import ch.cyberduck.core.onedrive.features.GraphTouchFeature;
import ch.cyberduck.core.onedrive.features.GraphWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveEmailAccount;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public abstract class GraphSession
extends HttpSession<OneDriveAPI> {
    private static final Logger log = Logger.getLogger(GraphSession.class);
    private OAuth2RequestInterceptor authorizationService;
    protected final GraphFileIdProvider fileIdProvider = new GraphFileIdProvider(this);

    protected GraphSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public OneDriveItem toItem(Path currentPath) throws BackgroundException {
        return this.toItem(currentPath, true);
    }

    public abstract OneDriveItem toItem(Path var1, boolean var2) throws BackgroundException;

    public boolean isAccessible(Path path) {
        return this.isAccessible(path, true);
    }

    public abstract boolean isAccessible(Path var1, boolean var2);

    public abstract Path getContainer(Path var1);

    public OneDriveFile toFile(Path file) throws BackgroundException {
        return this.toFile(file, true);
    }

    public OneDriveFile toFile(Path file, boolean resolveLastItem) throws BackgroundException {
        OneDriveItem item = this.toItem(file, resolveLastItem);
        if (!(item instanceof OneDriveFile)) {
            throw new NotfoundException(String.format("%s is not a file.", file.getAbsolute()));
        }
        return (OneDriveFile)item;
    }

    public OneDriveFolder toFolder(Path file) throws BackgroundException {
        return this.toFolder(file, true);
    }

    public OneDriveFolder toFolder(Path file, boolean resolveLastItem) throws BackgroundException {
        OneDriveItem item = this.toItem(file, resolveLastItem);
        if (!(item instanceof OneDriveFolder)) {
            throw new NotfoundException(String.format("%s is not a folder.", file.getAbsolute()));
        }
        return (OneDriveFolder)item;
    }

    protected OneDriveAPI connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)configuration.build(), this.host.getProtocol()){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request.containsHeader("Authorization")) {
                    super.process(request, context);
                }
            }
        }.withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        final GraphCommonsHttpRequestExecutor executor = new GraphCommonsHttpRequestExecutor(configuration.build()){

            public void addAuthorizationHeader(Set<RequestHeader> headers) {
                headers.add(new RequestHeader("Authorization", "Bearer"));
            }
        };
        return new OneDriveAPI(){

            public RequestExecutor getExecutor() {
                return executor;
            }

            public boolean isBusinessConnection() {
                return false;
            }

            public boolean isGraphConnection() {
                if (StringUtils.equals((CharSequence)"graph.microsoft.com", (CharSequence)GraphSession.this.host.getHostname())) {
                    return true;
                }
                return StringUtils.equals((CharSequence)"graph.microsoft.de", (CharSequence)GraphSession.this.host.getHostname());
            }

            public String getBaseURL() {
                return String.format("%s://%s%s", GraphSession.this.host.getProtocol().getScheme(), GraphSession.this.host.getHostname(), GraphSession.this.host.getProtocol().getContext());
            }

            public String getEmailURL() {
                return String.format("%s://%s%s", GraphSession.this.host.getProtocol().getScheme(), GraphSession.this.host.getHostname(), "/v1.0/me");
            }
        };
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel));
        try {
            String account = OneDriveEmailAccount.getCurrentUserEmailAccount((OneDriveAPI)((OneDriveAPI)this.client));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Authenticated as user %s", account));
            }
            this.host.getCredentials().setUsername(account);
        }
        catch (OneDriveAPIException e) {
            log.warn((Object)String.format("Failure reading current user properties probably missing user.read scope. %s.", e.getMessage()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((OneDriveAPI)this.client).getExecutor().close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == IdProvider.class) {
            return (T)this.fileIdProvider;
        }
        if (type == AttributesFinder.class) {
            return (T)new GraphAttributesFinderFeature(this);
        }
        if (type == Directory.class) {
            return (T)new GraphDirectoryFeature(this);
        }
        if (type == Read.class) {
            return (T)new GraphReadFeature(this);
        }
        if (type == Write.class) {
            return (T)new GraphWriteFeature(this);
        }
        if (type == MultipartWrite.class) {
            return (T)new GraphBufferWriteFeature(this);
        }
        if (type == Delete.class) {
            return (T)new GraphDeleteFeature(this);
        }
        if (type == Touch.class) {
            return (T)new GraphTouchFeature(this);
        }
        if (type == Move.class) {
            return (T)new GraphMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new GraphCopyFeature(this);
        }
        if (type == Find.class) {
            return (T)new GraphFindFeature(this);
        }
        if (type == Search.class) {
            return (T)new GraphSearchFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new GraphTimestampFeature(this));
        }
        if (type == Quota.class) {
            return (T)new GraphQuotaFeature(this);
        }
        return (T)super._getFeature(type);
    }
}

