/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.GraphItemListService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.OneDriveSharedWithMeListService;
import java.util.EnumSet;

public class OneDriveListService
implements ListService {
    private static final String MYFILES_ID = "MYFILES_NAME";
    public static final Path MYFILES_NAME = new Path("/My Files", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.placeholder, AbstractPath.Type.directory), new PathAttributes().withVersionId("MYFILES_NAME"));
    private static final String SHARED_ID = "SHARED_NAME";
    public static final Path SHARED_NAME = new Path("/Shared", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.placeholder, AbstractPath.Type.directory), new PathAttributes().withVersionId("SHARED_NAME"));
    private final GraphSession session;

    public OneDriveListService(GraphSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            AttributedList list = new AttributedList();
            list.add((Referenceable)MYFILES_NAME);
            list.add((Referenceable)SHARED_NAME);
            listener.chunk(directory, list);
            return list;
        }
        if (SHARED_NAME.equals((Object)directory)) {
            return new OneDriveSharedWithMeListService(this.session).list(directory, listener);
        }
        return new GraphItemListService(this.session).list(directory, listener);
    }
}

