/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.OneDriveHomeFinderService;
import ch.cyberduck.core.onedrive.OneDriveListService;
import ch.cyberduck.core.onedrive.OneDriveSharingLinkUrlProvider;
import ch.cyberduck.core.onedrive.OneDriveUrlProvider;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDrivePackageItem;
import org.nuxeo.onedrive.client.OneDriveResource;

public class OneDriveSession
extends GraphSession {
    public OneDriveSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public OneDriveItem toItem(Path file, boolean resolveLastItem) throws BackgroundException {
        String itemId;
        String driveId;
        if (file.equals((Object)OneDriveListService.MYFILES_NAME)) {
            return OneDriveDrive.getDefaultDrive((OneDriveAPI)((OneDriveAPI)this.getClient())).getRoot();
        }
        String versionId = this.fileIdProvider.getFileid(file, (ListProgressListener)new DisabledListProgressListener());
        if (StringUtils.isEmpty((CharSequence)versionId)) {
            throw new NotfoundException(String.format("Version ID for %s is empty", file.getAbsolute()));
        }
        String[] idParts = versionId.split(String.valueOf('/'));
        if (idParts.length == 2 || !resolveLastItem) {
            driveId = idParts[0];
            itemId = idParts[1];
        } else if (idParts.length == 4) {
            driveId = idParts[2];
            itemId = idParts[3];
        } else {
            throw new NotfoundException(file.getAbsolute());
        }
        OneDriveDrive drive = new OneDriveDrive((OneDriveAPI)this.getClient(), driveId);
        if (file.getType().contains(AbstractPath.Type.file)) {
            return new OneDriveFile((OneDriveAPI)this.getClient(), drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        if (file.getType().contains(AbstractPath.Type.directory)) {
            return new OneDriveFolder((OneDriveAPI)this.getClient(), (OneDriveResource)drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        if (file.getType().contains(AbstractPath.Type.placeholder)) {
            return new OneDrivePackageItem((OneDriveAPI)this.getClient(), (OneDriveResource)drive, itemId, OneDriveItem.ItemIdentifierType.Id);
        }
        throw new NotfoundException(file.getAbsolute());
    }

    @Override
    public boolean isAccessible(Path file, boolean container) {
        if (file.isRoot()) {
            return false;
        }
        return !OneDriveListService.SHARED_NAME.equals((Object)file);
    }

    @Override
    public Path getContainer(Path file) {
        return new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder));
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new OneDriveListService(this);
        }
        if (type == UrlProvider.class) {
            return (T)new OneDriveUrlProvider();
        }
        if (type == PromptUrlProvider.class) {
            return (T)new OneDriveSharingLinkUrlProvider(this);
        }
        if (type == Home.class) {
            return (T)((Object)new OneDriveHomeFinderService(this));
        }
        return super._getFeature(type);
    }
}

