/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractItemListService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import java.util.Iterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveItemIterator;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveSharedWithMeListService
extends AbstractItemListService {
    private static final URLTemplate SHAREDWITHME_LIST_URL = new URLTemplate("/drive/sharedWithMe");
    private final GraphSession session;

    public OneDriveSharedWithMeListService(GraphSession session) {
        super(new GraphAttributesFinderFeature(session));
        this.session = session;
    }

    @Override
    protected Iterator<OneDriveItem.Metadata> getIterator(Path directory) throws BackgroundException {
        return new OneDriveItemIterator((OneDriveAPI)this.session.getClient(), SHAREDWITHME_LIST_URL.build(((OneDriveAPI)this.session.getClient()).getBaseURL()));
    }

    @Override
    protected Path toPath(OneDriveItem.Metadata metadata, Path directory) {
        Path path = super.toPath(metadata, directory);
        path.getType().add(AbstractPath.Type.shared);
        return super.toPath(metadata, directory);
    }
}

